/*
 * Decompiled with CFR 0.152.
 */
import cloud.lesh.CPUSim64.AsmIO;
import cloud.lesh.CPUSim64.AssemblerVisitor;
import cloud.lesh.CPUSim64.IncludeLoader;
import cloud.lesh.CPUSim64.LabelVisitor;
import cloud.lesh.CPUSim64.LiteralRewriter;
import cloud.lesh.CPUSim64.PreprocessorVisitor;
import cloud.lesh.CPUSim64.Simulator;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;

public class Assembler {
    public static void main(String[] args) throws Exception {
        String filename;
        System.out.println("=".repeat(80));
        System.out.println("CPUSim64 2.0.1 Assembler");
        System.out.println("\u00a92025\u20132026 Richard Lesh");
        System.out.println("Assembles .asm source files into .obj.gz binary files.");
        System.out.println("=".repeat(80));
        if (args.length < 1) {
            System.err.println("Usage: assemble [--DEBUG] [--hasMain] [-Dsymbol[=value]] <input.asm>");
            System.exit(2);
        }
        boolean hasMain = false;
        Path inPath = Path.of("", new String[0]);
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.charAt(0) == '-') {
                if (!arg.equals("--hasMain")) continue;
                hasMain = true;
                continue;
            }
            inPath = Path.of(arg, new String[0]).toAbsolutePath();
        }
        if (!Files.isRegularFile(inPath, new LinkOption[0])) {
            System.err.println("Can't find file: " + inPath.toString());
            System.exit(3);
        }
        if ((filename = inPath.getFileName().toString()).endsWith(".asm")) {
            filename = filename.substring(0, filename.length() - 4);
        }
        String outName = filename + ".obj.gz";
        Path outPath = inPath.getParent().resolve(outName);
        try {
            String source = Files.readString(inPath);
            IncludeLoader loader = new IncludeLoader(inPath.getParent());
            PreprocessorVisitor.resetGlobals();
            PreprocessorVisitor pp = new PreprocessorVisitor(inPath.getFileName().toString(), loader);
            String preprocessed = pp.preprocessText(source, args);
            if (preprocessed == null || preprocessed.isEmpty()) {
                System.err.println("Error: too many preprocessor errors!");
                System.exit(2);
            }
            LiteralRewriter rw = new LiteralRewriter();
            preprocessed = rw.rewrite(preprocessed, pp.getSourceLocations());
            LabelVisitor labelVisitor = new LabelVisitor();
            String noLabels = labelVisitor.gatherLabels(preprocessed = PreprocessorVisitor.addGlobals(preprocessed, hasMain));
            if (noLabels == null || noLabels.isEmpty() || labelVisitor.hasErrors()) {
                System.err.println("Error: too many assembler errors!");
                System.exit(2);
            }
            Map<String, Long> labelMap = labelVisitor.getLabelMap();
            Map<Long, String> reverseLabelMap = labelVisitor.getReverseLabelMap();
            AssemblerVisitor asm = new AssemblerVisitor(labelMap, reverseLabelMap);
            asm.assemble(noLabels);
            List<Long> words = asm.result();
            if (words == null || words.isEmpty() || asm.hasErrors()) {
                System.err.println("Error: too many assembler errors!");
                System.exit(2);
            }
            if (labelMap.containsKey("__MAIN__")) {
                words.set(0, labelMap.get("__MAIN__"));
            } else {
                words.set(0, 1L);
            }
            AsmIO.writeU64BE(outPath, words);
            System.out.println("Wrote " + words.size() + " words to " + outPath.toString());
            Path symbolFile = inPath.getParent().resolve(filename + ".sym");
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(symbolFile.toFile()));){
                for (Map.Entry<String, Long> entry : labelMap.entrySet()) {
                    writer.write(entry.getKey() + ": " + String.valueOf(entry.getValue()));
                    writer.newLine();
                }
            }
            catch (IOException e) {
                System.err.println("Error writing label map: " + e.getMessage());
            }
            Path symbolFile1 = inPath.getParent().resolve(filename + ".sym1");
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(symbolFile1.toFile()));){
                for (Map.Entry<Long, String> entry : reverseLabelMap.entrySet()) {
                    writer.write(String.valueOf(entry.getKey()) + ": " + entry.getValue());
                    writer.newLine();
                }
            }
            catch (IOException e) {
                System.err.println("Error writing reverse label map: " + e.getMessage());
            }
            Map<String, Simulator.LabelType> types = asm.getLabelTypes();
            Path path = inPath.getParent().resolve(filename + ".sym2");
            try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(path.toFile()));){
                for (Map.Entry<String, Simulator.LabelType> entry : types.entrySet()) {
                    bufferedWriter.write(entry.getKey() + ": " + String.valueOf((Object)entry.getValue()));
                    bufferedWriter.newLine();
                }
            }
            catch (IOException iOException) {
                System.err.println("Error writing label type map: " + iOException.getMessage());
            }
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
        System.exit(0);
    }
}

