/*
 * Decompiled with CFR 0.152.
 */
import cloud.lesh.CPUSim64.AsmIO;
import cloud.lesh.CPUSim64.Simulator;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Disassembler {
    private static final String fmtLabel = "%08x: %s";

    public static void main(String[] args) throws Exception {
        Path originalPath;
        System.out.println("=".repeat(80));
        System.out.println("CPUSim64 2.0.1 Disassembler");
        System.out.println("\u00a92025\u20132026 Richard Lesh");
        System.out.println("Disassembles .obj.gz object files into source code.");
        System.out.println("=".repeat(80));
        if (args.length < 1) {
            System.err.println("Usage: disassemble [-mainOnly] <input.obj.gz>");
            System.exit(2);
        }
        boolean mainOnly = false;
        String filespec = "";
        ArrayList<String> simulatorArgs = new ArrayList<String>();
        for (String arg : args) {
            if (arg.charAt(0) == '-') {
                if (arg.equals("--mainOnly")) {
                    mainOnly = true;
                    continue;
                }
                System.err.println("Unknown option: " + arg);
                System.exit(1);
                continue;
            }
            simulatorArgs.add(arg);
        }
        Path newPath = originalPath = Path.of((String)simulatorArgs.get(0), new String[0]).toAbsolutePath();
        Path symbolPath = originalPath;
        Map<String, Long> symbolMap = null;
        Map<Long, String> reverseSymbolMap = null;
        Map<String, Simulator.LabelType> symbolTypes = null;
        String fileName = newPath.getFileName().toString();
        int dot = fileName.indexOf(46);
        String baseName = dot == -1 ? fileName : fileName.substring(0, dot);
        newPath = originalPath.resolveSibling(baseName + ".obj.gz");
        System.out.println("Looking for object file: " + newPath.toString());
        if (!Files.isRegularFile(newPath, new LinkOption[0]) && !Files.isRegularFile(newPath = originalPath.resolveSibling(baseName + ".obj"), new LinkOption[0])) {
            throw new RuntimeException("Can't locate object file for program: " + baseName);
        }
        symbolPath = originalPath.resolveSibling(baseName + ".sym");
        if (!Files.isRegularFile(symbolPath, new LinkOption[0])) {
            System.out.println("Can't locate label file for program: " + baseName);
        } else {
            symbolMap = Simulator.readLabelMapFromFile(symbolPath.toFile());
        }
        symbolPath = originalPath.resolveSibling(baseName + ".sym1");
        if (!Files.isRegularFile(symbolPath, new LinkOption[0])) {
            System.out.println("Can't locate reverse label file for program: " + baseName);
        } else {
            reverseSymbolMap = Simulator.readReverseLabelMapFromFile(symbolPath.toFile());
            if (reverseSymbolMap.get(0L) == null) {
                reverseSymbolMap.put(0L, "__START__");
            }
        }
        symbolPath = originalPath.resolveSibling(baseName + ".sym2");
        if (!Files.isRegularFile(symbolPath, new LinkOption[0])) {
            System.out.println("Can't locate label type file for program: " + baseName);
        } else {
            symbolTypes = Simulator.readLabelTypesFromFile(symbolPath.toFile());
        }
        List<Long> program = AsmIO.readU64BE(newPath.toFile());
        System.out.println("Read " + program.size() + " words from " + newPath.getFileName().toString());
        Simulator sim = new Simulator(program.size(), 0, 1024, (String[])simulatorArgs.toArray(String[]::new));
        sim.loadProgram(program, 0L, reverseSymbolMap);
        System.out.println(sim.disassemble(mainOnly ? program.get(0) : 1L, symbolTypes));
        System.out.println("=".repeat(80));
        System.out.println("Labels");
        System.out.println("=".repeat(80));
        ArrayList<String> keys = new ArrayList<String>(symbolMap.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            System.out.println(String.format(fmtLabel, symbolMap.get(key), key));
        }
    }
}

