/*
 * Decompiled with CFR 0.152.
 */
import cloud.lesh.CPUSim64.IncludeLoader;
import cloud.lesh.CPUSim64.LiteralRewriter;
import cloud.lesh.CPUSim64.PreprocessorVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class Preprocessor {
    public static void main(String[] args) throws Exception {
        String filename;
        System.out.println("=".repeat(80));
        System.out.println("CPUSim64 2.0.1 Preprocessor");
        System.out.println("\u00a92025\u20132026 Richard Lesh");
        System.out.println("Preprocesses .asm source files into .pp.asm files.");
        System.out.println("=".repeat(80));
        if (args.length < 1) {
            System.err.println("Usage: preprocessor [--DEBUG] [--hasMain] [-Dsymbol[=value]] <input.asm>");
            System.exit(2);
        }
        boolean hasMain = false;
        Path inPath = Path.of("", new String[0]);
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.charAt(0) == '-') {
                if (!arg.equals("--hasMain")) continue;
                hasMain = true;
                continue;
            }
            inPath = Path.of(arg, new String[0]).toAbsolutePath();
        }
        if (!Files.isRegularFile(inPath, new LinkOption[0])) {
            System.err.println("Can't find file: " + inPath.toString());
            System.exit(3);
        }
        if ((filename = inPath.getFileName().toString()).endsWith(".asm")) {
            filename = filename.substring(0, filename.length() - 4);
        }
        String outName = filename + ".pp.asm";
        Path outPath = inPath.getParent().resolve(outName);
        try {
            String source = Files.readString(inPath);
            IncludeLoader loader = new IncludeLoader(inPath.getParent());
            PreprocessorVisitor.resetGlobals();
            PreprocessorVisitor pp = new PreprocessorVisitor(inPath.getFileName().toString(), loader);
            String preprocessed = pp.preprocessText(source, args);
            if (preprocessed == null || preprocessed.isEmpty()) {
                System.err.println("Error: too many preprocessor errors!");
                System.exit(2);
            }
            Files.writeString(outPath, (CharSequence)preprocessed, new OpenOption[0]);
            LiteralRewriter rw = new LiteralRewriter();
            preprocessed = rw.rewrite(preprocessed, pp.getSourceLocations());
            preprocessed = PreprocessorVisitor.addGlobals(preprocessed, hasMain);
            Files.writeString(outPath, (CharSequence)preprocessed, new OpenOption[0]);
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
    }
}

