/*
 * Decompiled with CFR 0.152.
 */
import cloud.lesh.CPUSim64.AsmIO;
import cloud.lesh.CPUSim64.Simulator;
import cloud.lesh.CPUSim64.Utils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Simulation {
    public static void main(String[] args) throws Exception {
        Path originalPath;
        if (args.length < 1) {
            System.err.println("Usage: simulation [--debug] [--trace] [--verbose] \n        [--mem=memsize] [--stack=stacksize] <input.obj.gz>");
            System.exit(2);
        }
        boolean debug = false;
        boolean trace = false;
        boolean verbose = false;
        int memorySize = 0x100000;
        int stackSize = 8192;
        String filespec = "";
        ArrayList<String> simulatorArgs = new ArrayList<String>();
        for (String arg : args) {
            if (arg.charAt(0) == '-') {
                if (arg.equals("--debug")) {
                    debug = true;
                    continue;
                }
                if (arg.equals("--trace") || arg.equals("-t")) {
                    trace = true;
                    continue;
                }
                if (arg.equals("--verbose") || arg.equals("-v")) {
                    verbose = true;
                    continue;
                }
                if (arg.startsWith("--mem=")) {
                    try {
                        memorySize = Utils.decodeSI(arg.substring("--mem=".length()));
                    }
                    catch (NumberFormatException e) {
                        System.err.println("Invalid memory size: " + arg);
                        System.exit(1);
                    }
                    continue;
                }
                if (arg.startsWith("--stack=")) {
                    try {
                        stackSize = Utils.decodeSI(arg.substring("--stack=".length()));
                    }
                    catch (NumberFormatException e) {
                        System.err.println("Invalid stack size: " + arg);
                        System.exit(1);
                    }
                    continue;
                }
                simulatorArgs.add(arg);
                continue;
            }
            simulatorArgs.add(arg);
        }
        if (verbose) {
            System.out.println("=".repeat(80));
            System.out.println("CPUSim64 2.0.1 Emulator");
            System.out.println("\u00a92025\u20132026 Richard Lesh");
            System.out.println("Implements a CPUSim64 Virtual Machine.");
            System.out.println("=".repeat(80));
            System.out.println("Debug: " + debug);
            System.out.println("Memory size: " + memorySize);
            System.out.println("Stack size: " + stackSize);
        }
        Path newPath = originalPath = Path.of((String)simulatorArgs.get(0), new String[0]).toAbsolutePath();
        Path symbolPath = originalPath;
        Object symbolMap = null;
        Map<Long, String> reverseSymbolMap = null;
        String fileName = newPath.getFileName().toString();
        int dot = fileName.indexOf(46);
        String baseName = dot == -1 ? fileName : fileName.substring(0, dot);
        newPath = originalPath.resolveSibling(baseName + ".obj.gz");
        if (!Files.isRegularFile(newPath, new LinkOption[0]) && !Files.isRegularFile(newPath = originalPath.resolveSibling(baseName + ".obj"), new LinkOption[0])) {
            throw new RuntimeException("Can't locate object file for program: " + baseName);
        }
        symbolPath = originalPath.resolveSibling(baseName + ".sym1");
        if (!Files.isRegularFile(symbolPath, new LinkOption[0])) {
            System.out.println("Can't locate reverse label file for program: " + baseName);
        } else {
            reverseSymbolMap = Simulator.readReverseLabelMapFromFile(symbolPath.toFile());
            if (reverseSymbolMap.get(0L) == null) {
                reverseSymbolMap.put(0L, "__START__");
            }
        }
        List<Long> program = AsmIO.readU64BE(newPath.toFile());
        if (verbose || debug) {
            System.out.println("Read " + program.size() + " words from " + newPath.getFileName().toString());
        }
        Simulator sim = new Simulator(memorySize, 0, stackSize, (String[])simulatorArgs.toArray(String[]::new));
        if (debug) {
            sim.setDebug(true);
        }
        if (trace) {
            sim.setTrace(true);
        }
        sim.loadProgram(program, 0L, reverseSymbolMap);
        long result = sim.run(program.get(0));
        if (verbose) {
            System.out.println("Result: " + result);
            long totalTime = sim.getClock();
            System.out.printf("User CPU Cycles: %d\n", sim.getCycles());
            System.out.printf("User Time: %.3f sec\n", (double)(totalTime - sim.getSystemClock()) / 1.0E9);
            System.out.printf("System Time: %.3f sec\n", (double)sim.getSystemClock() / 1.0E9);
            System.out.printf("Total Time: %.3f sec\n", (double)totalTime / 1.0E9);
        }
    }
}

