/*
 * Decompiled with CFR 0.152.
 */
package cloud.lesh.CPUSim64;

import cloud.lesh.CPUSim64.CollectingErrorListener;
import cloud.lesh.CPUSim64.ConstExprBaseVisitor;
import cloud.lesh.CPUSim64.ConstExprLexer;
import cloud.lesh.CPUSim64.ConstExprParser;
import cloud.lesh.CPUSim64.HasLocation;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenStreamRewriter;
import org.antlr.v4.runtime.misc.Interval;

public final class ExpressionFolder
implements HasLocation {
    private Vector<String> errors = new Vector();
    private String filename;
    private int line;

    public Vector<String> getErrors() {
        return this.errors;
    }

    public ExpressionFolder(String filename, int line) {
        this.filename = filename;
        this.line = line;
    }

    @Override
    public String getLocation(int offendingLine) {
        return "\u00abfilename\u00bb:" + this.line;
    }

    public String fold(String input) {
        int i;
        this.errors = new Vector();
        CodePointCharStream cs = CharStreams.fromString(input);
        ConstExprLexer lexer = new ConstExprLexer(cs);
        CollectingErrorListener lexerListener = new CollectingErrorListener(this.errors, this);
        lexer.removeErrorListeners();
        lexer.addErrorListener(lexerListener);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        tokens.fill();
        ConstExprParser parser = new ConstExprParser(tokens);
        CollectingErrorListener parserListener = new CollectingErrorListener(this.errors, this);
        parser.removeErrorListeners();
        parser.addErrorListener(parserListener);
        ConstExprParser.LineContext tree = parser.line();
        ConstExprVisitor v = new ConstExprVisitor(tokens);
        TokenStreamRewriter rewriter = new TokenStreamRewriter(tokens);
        for (ConstExprParser.PartContext part : tree.part()) {
            if (!(part instanceof ConstExprParser.PartExprContext)) continue;
            ConstExprParser.PartExprContext pe = (ConstExprParser.PartExprContext)part;
            ConstExprResult r = (ConstExprResult)v.visit(pe.expr());
            if (!r.isConst) continue;
            int a = pe.getStart().getTokenIndex();
            int b = pe.getStop().getTokenIndex();
            rewriter.replace(a, b, (Object)r.text);
        }
        for (i = 0; i < this.errors.size(); ++i) {
            Matcher m;
            String s = this.errors.get(i);
            if (!s.startsWith("Preprocessed line") || !(m = Pattern.compile("Preprocessed line (\\d+)").matcher(s)).find()) continue;
            int preLine = Integer.parseInt(m.group(1));
            this.errors.set(i, m.replaceAll(Integer.toString(this.line)));
        }
        if (this.errors.size() > 0) {
            for (i = 0; i < this.errors.size(); ++i) {
                System.err.println(this.errors.get(i));
            }
            System.exit(1);
        }
        return rewriter.getText();
    }

    public static void main(String[] args) {
        String[] tests = new String[]{"Example: 1 + 2 * 3", "  1 +   2 *   ( 3 + 4 ) \"Hello+Goodbye\"", "-(1 + 2) * 3", "2 + 3.5 * 0x2", "'C' 10 / 4", "10.0 / 4"};
        ExpressionFolder folder = new ExpressionFolder("test", 1);
        for (String t : tests) {
            System.out.println("IN : [" + t + "]");
            System.out.println("OUT: [" + folder.fold(t) + "]");
            System.out.println();
        }
    }

    public static final class ConstExprVisitor
    extends ConstExprBaseVisitor<ConstExprResult> {
        private final CommonTokenStream tokens;

        public ConstExprVisitor(CommonTokenStream tokens) {
            this.tokens = tokens;
        }

        private String original(ParserRuleContext ctx) {
            Interval iv = ctx.getSourceInterval();
            return this.tokens.getText(iv);
        }

        private static boolean promoteToFloat(ConstExprResult a, ConstExprResult b, String op) {
            return a.isFloat || b.isFloat;
        }

        @Override
        public ConstExprResult visitLine(ConstExprParser.LineContext ctx) {
            StringBuilder out = new StringBuilder();
            for (ConstExprParser.PartContext p : ctx.part()) {
                ConstExprResult r = (ConstExprResult)this.visit(p);
                out.append(r.text);
            }
            return ConstExprResult.nonConst(out.toString());
        }

        @Override
        public ConstExprResult visitPartOther(ConstExprParser.PartOtherContext ctx) {
            return ConstExprResult.nonConst(this.original(ctx));
        }

        @Override
        public ConstExprResult visitPartChar(ConstExprParser.PartCharContext ctx) {
            return ConstExprResult.nonConst(this.original(ctx));
        }

        @Override
        public ConstExprResult visitPartString(ConstExprParser.PartStringContext ctx) {
            return ConstExprResult.nonConst(this.original(ctx));
        }

        @Override
        public ConstExprResult visitPartExpr(ConstExprParser.PartExprContext ctx) {
            ConstExprResult r = (ConstExprResult)this.visit(ctx.expr());
            if (r.isConst) {
                return r;
            }
            return ConstExprResult.nonConst(this.original(ctx));
        }

        @Override
        public ConstExprResult visitExpr(ConstExprParser.ExprContext ctx) {
            ConstExprResult r = (ConstExprResult)this.visit(ctx.addExpr());
            return r;
        }

        @Override
        public ConstExprResult visitPrimary(ConstExprParser.PrimaryContext ctx) {
            if (ctx.INT() != null) {
                String s = ctx.INT().getText();
                long v = Long.parseLong(s);
                return ConstExprResult.constLong(v);
            }
            if (ctx.HEXINT() != null) {
                String s = ctx.HEXINT().getText();
                long v = Long.decode(s);
                return ConstExprResult.constLong(v);
            }
            if (ctx.FLOAT() != null) {
                String s = ctx.FLOAT().getText();
                double v = Double.parseDouble(s);
                return ConstExprResult.constDouble(v);
            }
            if (ctx.addExpr() != null) {
                return (ConstExprResult)this.visit(ctx.addExpr());
            }
            return ConstExprResult.nonConst(this.original(ctx));
        }

        @Override
        public ConstExprResult visitUnaryExpr(ConstExprParser.UnaryExprContext ctx) {
            if (ctx.getChildCount() == 2 && "-".equals(ctx.getChild(0).getText())) {
                ConstExprResult inner = (ConstExprResult)this.visit(ctx.unaryExpr());
                if (inner.isConst) {
                    if (inner.isFloat) {
                        return ConstExprResult.constDouble(-inner.doubleVal);
                    }
                    return ConstExprResult.constLong(-inner.longVal);
                }
                return ConstExprResult.nonConst(this.original(ctx));
            }
            return (ConstExprResult)this.visit(ctx.primary());
        }

        @Override
        public ConstExprResult visitMulExpr(ConstExprParser.MulExprContext ctx) {
            if (ctx.op == null) {
                return (ConstExprResult)this.visit(ctx.unaryExpr());
            }
            ConstExprResult left = (ConstExprResult)this.visit(ctx.mulExpr());
            ConstExprResult right = (ConstExprResult)this.visit(ctx.unaryExpr());
            if (left.isConst && right.isConst) {
                String op = ctx.op.getText();
                boolean asFloat = ConstExprVisitor.promoteToFloat(left, right, op);
                if (asFloat) {
                    double a = left.isFloat ? left.doubleVal : (double)left.longVal;
                    double b = right.isFloat ? right.doubleVal : (double)right.longVal;
                    return switch (op) {
                        case "*" -> ConstExprResult.constDouble(a * b);
                        case "/" -> ConstExprResult.constDouble(a / b);
                        default -> ConstExprResult.nonConst(this.original(ctx));
                    };
                }
                long a = left.longVal;
                long b = right.longVal;
                return switch (op) {
                    case "*" -> ConstExprResult.constLong(a * b);
                    case "/" -> ConstExprResult.constLong(a / b);
                    default -> ConstExprResult.nonConst(this.original(ctx));
                };
            }
            return ConstExprResult.nonConst(this.original(ctx));
        }

        @Override
        public ConstExprResult visitAddExpr(ConstExprParser.AddExprContext ctx) {
            if (ctx.op == null) {
                return (ConstExprResult)this.visit(ctx.mulExpr());
            }
            ConstExprResult left = (ConstExprResult)this.visit(ctx.addExpr());
            ConstExprResult right = (ConstExprResult)this.visit(ctx.mulExpr());
            if (left.isConst && right.isConst) {
                String op = ctx.op.getText();
                boolean asFloat = ConstExprVisitor.promoteToFloat(left, right, op);
                if (asFloat) {
                    double a = left.isFloat ? left.doubleVal : (double)left.longVal;
                    double b = right.isFloat ? right.doubleVal : (double)right.longVal;
                    return switch (op) {
                        case "+" -> ConstExprResult.constDouble(a + b);
                        case "-" -> ConstExprResult.constDouble(a - b);
                        default -> ConstExprResult.nonConst(this.original(ctx));
                    };
                }
                long a = left.longVal;
                long b = right.longVal;
                return switch (op) {
                    case "+" -> ConstExprResult.constLong(a + b);
                    case "-" -> ConstExprResult.constLong(a - b);
                    default -> ConstExprResult.nonConst(this.original(ctx));
                };
            }
            return ConstExprResult.nonConst(this.original(ctx));
        }
    }

    public static final class ConstExprResult {
        public final boolean isConst;
        public final boolean isFloat;
        public final long longVal;
        public final double doubleVal;
        public final String text;

        private ConstExprResult(boolean isConst, boolean isFloat, long longVal, double doubleVal, String text) {
            this.isConst = isConst;
            this.isFloat = isFloat;
            this.longVal = longVal;
            this.doubleVal = doubleVal;
            this.text = text;
        }

        public static ConstExprResult nonConst(String originalText) {
            return new ConstExprResult(false, false, 0L, 0.0, originalText);
        }

        public static ConstExprResult constLong(long v) {
            return new ConstExprResult(true, false, v, 0.0, Long.toString(v));
        }

        public static ConstExprResult constDouble(double v) {
            return new ConstExprResult(true, true, 0L, v, Double.toString(v));
        }
    }
}

