/*
 * Decompiled with CFR 0.152.
 */
package cloud.lesh.CPUSim64;

import cloud.lesh.CPUSim64.CPUSim64BaseVisitor;
import cloud.lesh.CPUSim64.CPUSim64Lexer;
import cloud.lesh.CPUSim64.CPUSim64Parser;
import cloud.lesh.CPUSim64.HasLocation;
import cloud.lesh.CPUSim64.Utils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class LabelVisitor
extends CPUSim64BaseVisitor<Void>
implements HasLocation {
    private final StringBuilder out = new StringBuilder();
    private final Map<String, Long> labelMap = new HashMap<String, Long>();
    private final Map<Long, String> reverseLabelMap = new HashMap<Long, String>();
    private final Set<String> definedLabels = new HashSet<String>();
    private final Stack<String> blockNames = new Stack();
    private long currentAddress = 0L;
    private long blockCount = 0L;
    private boolean hasErrors = false;
    private Map<Integer, String> originalSourceLocations;
    String filename = null;
    int lineNum = 1;
    boolean pauseLineIncrement = false;
    Map<Integer, String> lineMap = new HashMap<Integer, String>();
    CommonTokenStream tokens;

    public void setTokens(CommonTokenStream tokens) {
        this.tokens = tokens;
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    @Override
    public String getLocation(int offendingLine) {
        String loc = this.originalSourceLocations.get(offendingLine);
        while (loc == null && offendingLine > 0) {
            loc = this.originalSourceLocations.get(--offendingLine);
        }
        return loc;
    }

    public Map<Integer, String> getLineMap() {
        return this.lineMap;
    }

    public Map<String, Long> getLabelMap() {
        this.labelMap.putIfAbsent("__START__", 0L);
        this.labelMap.putIfAbsent("__CODE__", 0L);
        this.labelMap.putIfAbsent("__CODE_END__", this.currentAddress);
        this.labelMap.putIfAbsent("__DATA__", this.currentAddress);
        this.labelMap.putIfAbsent("__DATA_END__", this.currentAddress);
        this.labelMap.putIfAbsent("__HEAP_START__", this.currentAddress);
        return this.labelMap;
    }

    public Map<Long, String> getReverseLabelMap() {
        return this.reverseLabelMap;
    }

    private static Token startToken(ParseTree node) {
        if (node instanceof ParserRuleContext) {
            ParserRuleContext r = (ParserRuleContext)node;
            return r.getStart();
        }
        if (node instanceof TerminalNode) {
            TerminalNode t = (TerminalNode)node;
            return t.getSymbol();
        }
        if (node instanceof ErrorNode) {
            ErrorNode e = (ErrorNode)node;
            return e.getSymbol();
        }
        return null;
    }

    private long parseIntLike(String text) {
        if (text.startsWith("0x") || text.startsWith("0X")) {
            return Long.parseUnsignedLong(text.substring(2), 16);
        }
        if (text.startsWith("-0x") || text.startsWith("-0X")) {
            return -Long.parseUnsignedLong(text.substring(3), 16);
        }
        if (text.charAt(0) == '-' || text.charAt(0) >= '0' && text.charAt(0) <= '9') {
            return Long.parseLong(text);
        }
        throw new IllegalArgumentException("Can't parse integer: " + text);
    }

    @Override
    public Void visitProgram(CPUSim64Parser.ProgramContext ctx) {
        for (ParseTree child : ctx.children) {
            this.visit(child);
            Token t = LabelVisitor.startToken(child);
            if (t == null) continue;
            int line = t.getLine();
            int col = t.getCharPositionInLine();
            this.lineMap.put(line, this.getLocation(this.lineNum));
        }
        return null;
    }

    private String getScopeName() {
        return String.join((CharSequence)"$", this.blockNames).toUpperCase();
    }

    @Override
    public Void visitLabelDef(CPUSim64Parser.LabelDefContext ctx) {
        Object labelName = ctx.IDENT().getText().toUpperCase();
        if (this.definedLabels.contains(labelName)) {
            System.err.println(this.getLocation(this.lineNum) + ":ASMERROR:Duplicate label '" + (String)labelName + "'");
            this.hasErrors = true;
        } else {
            if (((String)labelName).charAt(0) == '$') {
                labelName = this.getScopeName() + (String)labelName;
            }
            this.definedLabels.add((String)labelName);
            this.labelMap.put((String)labelName, this.currentAddress);
            this.reverseLabelMap.put(this.currentAddress, (String)labelName);
        }
        return null;
    }

    @Override
    public Void visitInstruction(CPUSim64Parser.InstructionContext ctx) {
        ++this.currentAddress;
        String s = this.reflowTokens(ctx) + System.lineSeparator();
        this.out.append(s);
        return null;
    }

    @Override
    public Void visitData_Directive(CPUSim64Parser.Data_DirectiveContext ctx) {
        if (ctx.dataDirective() != null) {
            if (ctx.dataDirective().DCI() != null) {
                ++this.currentAddress;
            } else if (ctx.dataDirective().DCF() != null) {
                ++this.currentAddress;
            } else if (ctx.dataDirective().DCS() != null) {
                if (ctx.dataDirective().STRINGLIT() == null || ctx.dataDirective().STRINGLIT().getText().length() < 2) {
                    System.err.println(this.getLocation(this.lineNum) + ":ASMERROR:Missing string literal for .DCS directive");
                    this.hasErrors = true;
                    return null;
                }
                String s = ctx.dataDirective().STRINGLIT().getText();
                s = s.substring(1, s.length() - 1);
                byte[] utf8 = Utils.parseStringLiteral(s);
                this.currentAddress += (long)(1 + (utf8.length + 7) / 8);
            } else if (ctx.dataDirective().DCA() != null) {
                long b = 0L;
                if (ctx.dataDirective().INTLIT() != null) {
                    b = this.parseIntLike(ctx.dataDirective().INTLIT().getText());
                } else if (ctx.dataDirective().HEXLIT() != null) {
                    b = this.parseIntLike(ctx.dataDirective().HEXLIT().getText());
                }
                this.currentAddress += 1L + b;
            } else if (ctx.dataDirective().DCB() != null) {
                this.currentAddress += (long)(1 + (ctx.dataDirective().byteList().bLiteral().size() + 7) / 8);
            } else if (ctx.dataDirective().DCC() != null) {
                this.currentAddress += (long)(1 + (ctx.dataDirective().byteList().bLiteral().size() + 3) / 4);
            } else if (ctx.dataDirective().DCW() != null) {
                int count = 0;
                if (ctx.dataDirective().intList() != null) {
                    count = ctx.dataDirective().intList().kLiteral().size();
                } else if (ctx.dataDirective().floatList() != null) {
                    count = ctx.dataDirective().floatList().FLOATLIT().size();
                } else if (ctx.dataDirective().charList() != null) {
                    count = ctx.dataDirective().charList().CHARLIT().size();
                }
                this.currentAddress += (long)(1 + count);
            }
        }
        this.out.append(this.reflowTokens(ctx) + System.lineSeparator());
        return null;
    }

    @Override
    public Void visitORG_Directive(CPUSim64Parser.ORG_DirectiveContext ctx) {
        if (ctx.INTLIT() != null) {
            this.currentAddress = Long.parseLong(ctx.INTLIT().getText());
        } else if (ctx.HEXLIT() != null) {
            this.currentAddress = Long.parseLong(ctx.HEXLIT().getText().substring(2), 16);
        } else {
            System.err.println(this.getLocation(this.lineNum) + ":ASMERROR:Missing integer literal for .ORG directive");
            this.hasErrors = true;
            return null;
        }
        this.currentAddress = Math.max(0L, this.currentAddress);
        this.out.append(this.reflowTokens(ctx) + System.lineSeparator());
        return null;
    }

    @Override
    public Void visitLINE_Directive(CPUSim64Parser.LINE_DirectiveContext ctx) {
        this.filename = ctx.FILENAMELIT().getText();
        this.lineNum = ctx.INTLIT() != null ? Integer.parseInt(ctx.INTLIT().getText()) : 1;
        this.pauseLineIncrement = false;
        this.out.append(this.reflowTokens(ctx) + System.lineSeparator());
        return null;
    }

    @Override
    public Void visitLINE_BEGIN_Directive(CPUSim64Parser.LINE_BEGIN_DirectiveContext ctx) {
        this.filename = ctx.FILENAMELIT().getText();
        this.lineNum = ctx.INTLIT() != null ? Integer.parseInt(ctx.INTLIT().getText()) : 1;
        this.pauseLineIncrement = true;
        this.out.append(this.reflowTokens(ctx) + System.lineSeparator());
        return null;
    }

    @Override
    public Void visitLINE_END_Directive(CPUSim64Parser.LINE_END_DirectiveContext ctx) {
        this.pauseLineIncrement = false;
        this.out.append(this.reflowTokens(ctx) + System.lineSeparator());
        return null;
    }

    @Override
    public Void visitBLOCK_BEGIN_Directive(CPUSim64Parser.BLOCK_BEGIN_DirectiveContext ctx) {
        String blockname = null;
        if (ctx.IDENT() != null) {
            blockname = ctx.IDENT().getText();
        }
        if (blockname == null) {
            throw new IllegalArgumentException(".block directive must have an argument!");
        }
        if (blockname.contains("{}") || blockname.contains("%d") || blockname.contains("%x")) {
            blockname = String.format(blockname.replace("{}", "%04x"), ++this.blockCount);
        }
        this.blockNames.push(blockname);
        this.out.append(this.reflowTokens(ctx) + System.lineSeparator());
        return null;
    }

    @Override
    public Void visitBLOCK_END_Directive(CPUSim64Parser.BLOCK_END_DirectiveContext ctx) {
        this.blockNames.pop();
        this.out.append(this.reflowTokens(ctx) + System.lineSeparator());
        return null;
    }

    @Override
    protected Void defaultResult() {
        return null;
    }

    private String reflowTokens(ParserRuleContext ctx) {
        String s = Utils.rebuildWithSingleSpaces(this.tokens, ctx);
        return s;
    }

    public String gatherLabels(String src) {
        this.originalSourceLocations = Utils.readLineDirectives(src);
        CodePointCharStream input = CharStreams.fromString(src);
        CPUSim64Lexer lex = new CPUSim64Lexer(input);
        lex.removeErrorListeners();
        lex.addErrorListener(new LabelErrorListener());
        CommonTokenStream toks = new CommonTokenStream(lex);
        toks.fill();
        this.setTokens(toks);
        CPUSim64Parser parser = new CPUSim64Parser(toks);
        parser.removeErrorListeners();
        parser.addErrorListener(new LabelErrorListener());
        CPUSim64Parser.ProgramContext tree = parser.program();
        this.visit(tree);
        return this.out.toString();
    }

    final class LabelErrorListener
    extends BaseErrorListener {
        @Override
        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            String where = LabelVisitor.this.getLocation(line);
            Object tokenText = "";
            if (offendingSymbol instanceof Token) {
                Token t = (Token)offendingSymbol;
                tokenText = " near '" + t.getText() + "'";
            }
            System.err.println(where + ":ASMERROR:" + msg);
            LabelVisitor.this.hasErrors = true;
        }
    }
}

