/*
 * Decompiled with CFR 0.152.
 */
package cloud.lesh.CPUSim64;

import cloud.lesh.CPUSim64.CollectingErrorListener;
import cloud.lesh.CPUSim64.HasLocation;
import cloud.lesh.CPUSim64.LiteralSubstitutionBaseVisitor;
import cloud.lesh.CPUSim64.LiteralSubstitutionLexer;
import cloud.lesh.CPUSim64.LiteralSubstitutionParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Token;

public class LiteralRewriter
extends LiteralSubstitutionBaseVisitor<Void>
implements HasLocation {
    private final StringBuilder out = new StringBuilder();
    private final List<String> floats = new ArrayList<String>();
    private final List<String> strings = new ArrayList<String>();
    private static Vector<String> errors = new Vector();
    private Map<Integer, String> sourceLocations;

    public static Vector<String> getErrors() {
        return errors;
    }

    @Override
    public String getLocation(int offendingLine) {
        String originalSourceLocation = null;
        int line = offendingLine;
        originalSourceLocation = this.sourceLocations.get(line);
        while (originalSourceLocation == null && line > 0) {
            originalSourceLocation = this.sourceLocations.get(line);
            if (originalSourceLocation != null) continue;
            --line;
        }
        return originalSourceLocation == null ? "" : originalSourceLocation;
    }

    public String rewrite(String src) {
        return this.rewrite(src, new HashMap<Integer, String>());
    }

    public String rewrite(String src, Map<Integer, String> sourceLocations) {
        int i;
        this.sourceLocations = sourceLocations;
        errors = new Vector();
        CodePointCharStream input = CharStreams.fromString(src);
        LiteralSubstitutionLexer lexer = new LiteralSubstitutionLexer(input);
        CollectingErrorListener lexerListener = new CollectingErrorListener(errors, this);
        lexer.removeErrorListeners();
        lexer.addErrorListener(lexerListener);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        tokens.fill();
        LiteralSubstitutionParser parser = new LiteralSubstitutionParser(tokens);
        CollectingErrorListener parserListener = new CollectingErrorListener(errors, this);
        parser.removeErrorListeners();
        parser.addErrorListener(parserListener);
        LiteralSubstitutionParser.FileContext tree = parser.file();
        this.visit(tree);
        for (i = 0; i < errors.size(); ++i) {
            Matcher m;
            String s = errors.get(i);
            if (!s.startsWith("Preprocessed line") || !(m = Pattern.compile("Preprocessed line (\\d+)").matcher(s)).find()) continue;
            int preLine = Integer.parseInt(m.group(1));
            errors.set(i, m.replaceAll(Integer.toString(preLine)));
        }
        if (errors.size() > 0) {
            for (i = 0; i < errors.size(); ++i) {
                System.err.println(errors.get(i));
            }
            System.exit(1);
        }
        this.out.append(System.lineSeparator());
        for (i = 0; i < this.floats.size(); ++i) {
            this.out.append(LiteralRewriter.symFP(i + 1)).append(": .DCF ").append(this.floats.get(i)).append(System.lineSeparator());
        }
        for (i = 0; i < this.strings.size(); ++i) {
            this.out.append(LiteralRewriter.symSTR(i + 1)).append(": .DCS ").append(this.strings.get(i)).append(System.lineSeparator());
        }
        return this.out.toString();
    }

    private static String symFP(int i) {
        return String.format("__FP_%d", i);
    }

    private static String symSTR(int i) {
        return String.format("__STR_%d", i);
    }

    @Override
    public Void visitFile(LiteralSubstitutionParser.FileContext ctx) {
        return (Void)this.visitChildren(ctx);
    }

    @Override
    public Void visitPiece(LiteralSubstitutionParser.PieceContext ctx) {
        Token t = ctx.getStart();
        switch (t.getType()) {
            case 5: {
                if (this.floats.contains(t.getText())) {
                    int idx = this.floats.indexOf(t.getText()) + 1;
                    this.out.append(LiteralRewriter.symFP(idx));
                    break;
                }
                int idx = this.floats.size() + 1;
                this.floats.add(t.getText());
                this.out.append(LiteralRewriter.symFP(idx));
                break;
            }
            case 3: {
                if (this.strings.contains(t.getText())) {
                    int idx = this.strings.indexOf(t.getText()) + 1;
                    this.out.append(LiteralRewriter.symSTR(idx));
                    break;
                }
                int idx = this.strings.size() + 1;
                this.strings.add(t.getText());
                this.out.append(LiteralRewriter.symSTR(idx));
                break;
            }
            case 4: {
                int val = this.parseCharLiteral(t.getText());
                this.out.append(String.format("0x%X", val));
                break;
            }
            default: {
                this.out.append(t.getText());
            }
        }
        return null;
    }

    private int parseCharLiteral(String s) {
        if (s == null || s.isEmpty()) {
            return 65533;
        }
        if (s.length() >= 2 && s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'') {
            s = s.substring(1, s.length() - 1);
        }
        if (s.isEmpty()) {
            return 65533;
        }
        if (s.charAt(0) != '\\') {
            return s.codePointAt(0);
        }
        if (s.length() == 1) {
            return 65533;
        }
        char next = s.charAt(1);
        switch (next) {
            case '0': {
                return 0;
            }
            case 'n': {
                return 10;
            }
            case 't': {
                return 9;
            }
            case 'r': {
                return 13;
            }
            case 'b': {
                return 8;
            }
            case 'f': {
                return 12;
            }
            case '\\': {
                return 92;
            }
            case '\'': {
                return 39;
            }
            case '\"': {
                return 34;
            }
            case 'U': 
            case 'u': {
                String hex;
                int len = s.length();
                if (len > 4 && len <= 10 && (hex = s.substring(3, len - 1)).chars().allMatch(ch -> Character.digit(ch, 16) != -1)) {
                    return Integer.parseInt(hex, 16);
                }
                return 65533;
            }
        }
        return next;
    }
}

