/*
 * Decompiled with CFR 0.152.
 */
package cloud.lesh.CPUSim64;

import java.util.Arrays;

final class LongArray {
    private long[] data;
    private int size;

    public LongArray() {
        this(1024);
    }

    public LongArray(int capacity) {
        if (capacity < 1024) {
            capacity = 1024;
        }
        this.data = new long[capacity];
    }

    public synchronized void setSize(int newSize) {
        for (int i = this.size; i < newSize; ++i) {
            this.add(0L);
        }
    }

    public synchronized void add(long v) {
        if (this.size == this.data.length) {
            this.data = Arrays.copyOf(this.data, (int)((double)this.size * 1.2));
        }
        this.data[this.size++] = v;
    }

    public long get(int i) {
        if (i < 0 || i >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.data[i];
    }

    public synchronized void set(int i, long val) {
        if (i < 0 || i >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.data[i] = val;
    }

    public int size() {
        return this.size;
    }

    public long[] toArray() {
        return Arrays.copyOf(this.data, this.size);
    }
}

