/*
 * Decompiled with CFR 0.152.
 */
package cloud.lesh.CPUSim64;

import cloud.lesh.CPUSim64.PortHandler;
import cloud.lesh.CPUSim64.Simulator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class MemoryFilePortHandler
extends PortHandler {
    private ByteArrayOutputStream os;
    private ByteArrayInputStream bis;
    private InputStreamReader is;

    public MemoryFilePortHandler(Simulator cpu, int mode) throws Simulator.CPUException {
        this(cpu, mode, new byte[0]);
    }

    public MemoryFilePortHandler(Simulator cpu, int mode, byte[] data) throws Simulator.CPUException {
        super(cpu);
        try {
            switch (mode) {
                case 0: {
                    this.bis = new ByteArrayInputStream(data);
                    this.is = new InputStreamReader((InputStream)this.bis, StandardCharsets.UTF_8);
                    break;
                }
                case 1: {
                    this.os = new ByteArrayOutputStream();
                    break;
                }
                case 2: {
                    this.os = new ByteArrayOutputStream();
                    break;
                }
                default: {
                    throw new Exception();
                }
            }
        }
        catch (Exception e) {
            Simulator simulator = cpu;
            Objects.requireNonNull(simulator);
            throw simulator.new Simulator.CPUException("Memory file open error using mode " + mode + "!");
        }
    }

    @Override
    public int read() throws Simulator.CPUException {
        if (this.is == null) {
            Simulator simulator = this.cpu;
            Objects.requireNonNull(simulator);
            throw simulator.new Simulator.CPUException("Memory file not open for input!");
        }
        try {
            return this.bis.read();
        }
        catch (Exception e) {
            Simulator simulator = this.cpu;
            Objects.requireNonNull(simulator);
            throw simulator.new Simulator.CPUException("Read error on Memory file!");
        }
    }

    @Override
    public int readChar() throws Simulator.CPUException {
        int codePoint = -1;
        if (this.is == null) {
            Simulator simulator = this.cpu;
            Objects.requireNonNull(simulator);
            throw simulator.new Simulator.CPUException("Memory file not open for input!");
        }
        try {
            int ch1 = this.is.read();
            if (ch1 != -1) {
                char c1 = (char)ch1;
                if (Character.isHighSurrogate(c1)) {
                    int ch2 = this.is.read();
                    if (ch2 != -1) {
                        char c2 = (char)ch2;
                        if (Character.isLowSurrogate(c2)) {
                            codePoint = Character.toCodePoint(c1, c2);
                        } else {
                            codePoint = c1;
                            this.is.reset();
                        }
                    } else {
                        codePoint = c1;
                    }
                } else {
                    codePoint = c1;
                }
            }
        }
        catch (Exception e) {
            Simulator simulator = this.cpu;
            Objects.requireNonNull(simulator);
            throw simulator.new Simulator.CPUException("Read error on Memory file!");
        }
        return codePoint;
    }

    @Override
    public void write(byte x) throws Simulator.CPUException {
        if (this.os == null) {
            Simulator simulator = this.cpu;
            Objects.requireNonNull(simulator);
            throw simulator.new Simulator.CPUException("Memory file not open for output!");
        }
        try {
            this.os.write(x);
        }
        catch (Exception e) {
            Simulator simulator = this.cpu;
            Objects.requireNonNull(simulator);
            throw simulator.new Simulator.CPUException("Write error on Memory file!");
        }
    }

    @Override
    public void writeChar(int codePoint) throws Simulator.CPUException {
        if (this.os == null) {
            Simulator simulator = this.cpu;
            Objects.requireNonNull(simulator);
            throw simulator.new Simulator.CPUException("Memory file not open for output!");
        }
        try {
            StringBuilder sb = new StringBuilder();
            sb.appendCodePoint(codePoint);
            this.os.write(sb.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            Simulator simulator = this.cpu;
            Objects.requireNonNull(simulator);
            throw simulator.new Simulator.CPUException("Write error on Memory file!");
        }
    }

    @Override
    public void flush() throws Simulator.CPUException {
        if (this.os == null) {
            Simulator simulator = this.cpu;
            Objects.requireNonNull(simulator);
            throw simulator.new Simulator.CPUException("Memory file not open for output!");
        }
        try {
            this.os.flush();
        }
        catch (Exception e) {
            Simulator simulator = this.cpu;
            Objects.requireNonNull(simulator);
            throw simulator.new Simulator.CPUException("Flush error on Memory file!");
        }
    }

    @Override
    public void close() throws Simulator.CPUException {
        try {
            if (this.is != null) {
                this.is.close();
            }
            if (this.os != null) {
                this.os.close();
            }
        }
        catch (Exception e) {
            Simulator simulator = this.cpu;
            Objects.requireNonNull(simulator);
            throw simulator.new Simulator.CPUException("Error closing Memory file!");
        }
    }

    public String toString() {
        return this.os.toString(StandardCharsets.UTF_8);
    }

    public byte[] toBytes() {
        return this.os.toByteArray();
    }
}

