/*
 * Decompiled with CFR 0.152.
 */
package cloud.lesh.CPUSim64;

import cloud.lesh.CPUSim64.Simulator;

public abstract class PortHandler
implements Cloneable {
    protected Simulator cpu;
    private static final int REG_SIZE_BYTES = 8;
    private int port;
    private boolean littleEndian = false;
    private boolean error = false;
    private boolean eof = false;

    public PortHandler(Simulator cpu) {
        this.cpu = cpu;
    }

    public abstract int read() throws Simulator.CPUException;

    public abstract int readChar() throws Simulator.CPUException;

    public abstract void write(byte var1) throws Simulator.CPUException;

    public abstract void writeChar(int var1) throws Simulator.CPUException;

    public abstract void flush() throws Simulator.CPUException;

    public abstract void close() throws Simulator.CPUException;

    public boolean isError() {
        return this.error;
    }

    public boolean isEOF() {
        return this.eof;
    }

    public void setLittleEndian(boolean b) {
        this.littleEndian = b;
    }

    public final void setPort(int i) {
        this.port = i;
    }

    public final void setPort(long i) {
        this.port = (int)i;
    }

    public final int port() {
        return this.port;
    }

    public PortHandler duplicate(Simulator cpu) {
        PortHandler newPH = null;
        try {
            newPH = (PortHandler)this.clone();
            newPH.cpu = cpu;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return newPH;
    }

    public long read(int count) throws Simulator.CPUException {
        long result = 0L;
        if (count <= 0 || count > 8) {
            count = 8;
        }
        if (!this.littleEndian) {
            while (count-- > 0) {
                result <<= 8;
                int r = this.read();
                if (r == -1) {
                    this.eof = true;
                    return -1L;
                }
                result |= (long)(r & 0xFF);
            }
        } else {
            int shiftAmount = 0;
            while (count-- > 0) {
                result |= ((long)this.read() & 0xFFL) << shiftAmount;
                shiftAmount += 8;
            }
        }
        switch (count) {
            case 1: {
                result = Simulator.signExtend(result, 8);
                break;
            }
            case 2: {
                result = Simulator.signExtend(result, 16);
                break;
            }
            case 4: {
                result = Simulator.signExtend(result, 32);
                break;
            }
        }
        return result;
    }

    public short readShort() throws Simulator.CPUException {
        return (short)this.read(2);
    }

    public int readInt() throws Simulator.CPUException {
        return (int)this.read(4);
    }

    public long readLong() throws Simulator.CPUException {
        return this.read(8);
    }

    public double readDouble() throws Simulator.CPUException {
        return Double.longBitsToDouble(this.readLong());
    }

    public void write(long x, int count) throws Simulator.CPUException {
        if (count <= 0 || count > 8) {
            count = 8;
        }
        if (!this.littleEndian) {
            int shiftAmount = (count - 1) * 8;
            while (count-- > 0) {
                this.write((byte)(x >> shiftAmount & 0xFFL));
                shiftAmount -= 8;
            }
        } else {
            while (count-- > 0) {
                this.write((byte)(x & 0xFFL));
                x >>= 8;
            }
        }
    }

    public void write(short x) throws Simulator.CPUException {
        this.write(x, 2);
    }

    public void write(int x) throws Simulator.CPUException {
        this.write(x, 4);
    }

    public void write(long x) throws Simulator.CPUException {
        this.write(x, 8);
    }

    public void write(double x) throws Simulator.CPUException {
        this.write(Double.doubleToRawLongBits(x), 8);
    }
}

