/*
 * Decompiled with CFR 0.152.
 */
package cloud.lesh.CPUSim64;

import cloud.lesh.CPUSim64.ExpressionFolder;
import cloud.lesh.CPUSim64.PreprocessorLexer;
import cloud.lesh.CPUSim64.PreprocessorParser;
import cloud.lesh.CPUSim64.PreprocessorParserBaseVisitor;
import cloud.lesh.CPUSim64.Utils;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.lang3.tuple.Pair;

public class PreprocessorVisitor
extends PreprocessorParserBaseVisitor<Void> {
    CommonTokenStream tokens;
    String filename = null;
    int sourceLineNum = 1;
    static int preprocessedLineNum = 1;
    int pauseLineSync = 0;
    Stack<String> lineDirectives = new Stack();
    String funcName = "";
    boolean hasErrors = false;
    private static Map<Integer, String> sourceLocations = new HashMap<Integer, String>();
    private final IncludeLoader includeLoader;
    private final StringBuilder out = new StringBuilder();
    private Map<String, DefVal> defines = new HashMap<String, DefVal>();
    private Stack<Map<String, String>> scopes = new Stack();
    private boolean substituteInsideDirectives;
    private static final Pattern TOKEN = Pattern.compile("[A-Za-z_.$][A-Za-z0-9_.$]*");
    private static final Pattern PLACEHOLDER = Pattern.compile("\\$\\{(([A-Za-z_.$][A-Za-z0-9_.$]*)|\\.\\.\\.)\\}");
    Set<String> previouslyIncluded = new HashSet<String>();
    private static List<String> globals = new ArrayList<String>();
    private final Set<String> svarSet = new HashSet<String>();
    private final Set<String> varSet = new HashSet<String>();
    private final Set<String> fvarSet = new HashSet<String>();
    private String macroDefName;
    private String macroDefText;
    Map<String, Pair<List<String>, String>> macros = new HashMap<String, Pair<List<String>, String>>();

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public void setTokens(CommonTokenStream tok) {
        this.tokens = tok;
    }

    String getLocation() {
        return "\u00ab" + (this.filename == null ? "" : this.filename) + "\u00bb:" + this.sourceLineNum;
    }

    public Map<Integer, String> getSourceLocations() {
        return sourceLocations;
    }

    public PreprocessorVisitor(String filename, IncludeLoader loader) {
        this(filename, 1, loader);
    }

    public PreprocessorVisitor(String filename, int sourceLineNumber, IncludeLoader loader) {
        this.filename = filename;
        this.sourceLineNum = sourceLineNumber;
        this.includeLoader = Objects.requireNonNull(loader, "IncludeLoader is required");
        this.substituteInsideDirectives = true;
        this.pauseLineSync = 0;
        this.pushScope();
    }

    public String getOutput() {
        return this.out.toString();
    }

    public void addDefine(String name, DefVal value) {
        if (name == null || name.isEmpty() || value == null) {
            throw new PreprocessorException("Define name and value must be non-null");
        }
        if (this.defines.containsKey(name.toUpperCase())) {
            System.err.println(this.getLocation() + ":ERROR:Define name already exists: " + name);
            this.hasErrors = true;
        }
        this.defines.put(name.toUpperCase(), value);
    }

    public void addVar(String name, String value) {
        if (name == null || name.isEmpty() || value == null) {
            throw new PreprocessorException("Variable name and value must be non-null");
        }
        if (this.lookupVar(name = name.toUpperCase()) != null) {
            throw new PreprocessorException("Variable name already exists: " + name);
        }
        ((Map)this.scopes.lastElement()).put(name, value);
    }

    public String lookupVar(String name) {
        name = name.toUpperCase();
        for (int i = this.scopes.size() - 1; i >= 0; --i) {
            Map s = (Map)this.scopes.get(i);
            if (!s.containsKey(name)) continue;
            return (String)s.get(name);
        }
        return null;
    }

    public void pushScope() {
        this.scopes.push(new HashMap());
    }

    public void popScope() {
        this.scopes.pop();
    }

    private static int lineOf(ParseTree node) {
        if (node instanceof ParserRuleContext) {
            ParserRuleContext prc = (ParserRuleContext)node;
            Token t = prc.getStart();
            return t != null ? t.getLine() : -1;
        }
        if (node instanceof TerminalNode) {
            TerminalNode tn = (TerminalNode)node;
            Token t = tn.getSymbol();
            return t != null ? t.getLine() : -1;
        }
        return -1;
    }

    @Override
    public Void visitPreproc(PreprocessorParser.PreprocContext ctx) {
        this.emitLineDirective(this.filename, ctx);
        for (ParseTree child : ctx.children) {
            child.accept(this);
        }
        return null;
    }

    @Override
    public Void visitDirective(PreprocessorParser.DirectiveContext ctx) {
        this.emitLineDirective(this.filename, ctx);
        return (Void)this.visitChildren(ctx);
    }

    @Override
    public Void visitCodeLine(PreprocessorParser.CodeLineContext ctx) {
        this.emitLineDirective(this.filename, ctx);
        record Seg(int start, int stop, int type, String text) {
        }
        ArrayList<Seg> segs = new ArrayList<Seg>(ctx.more.size() + ctx.moreExpr.size());
        for (Token t : ctx.more) {
            segs.add(new Seg(t.getStartIndex(), t.getStopIndex(), t.getType(), t.getText()));
        }
        for (PreprocessorParser.ConstExprContext e : ctx.moreExpr) {
            Token a = e.getStart();
            Token b = e.getStop();
            segs.add(new Seg(a.getStartIndex(), b.getStopIndex(), -1, e.getText()));
        }
        segs.sort(Comparator.comparingInt(Seg::start));
        StringBuilder logical = new StringBuilder();
        boolean pendingSpace = false;
        for (Seg s : segs) {
            if (pendingSpace && logical.length() > 0 && s.type != 62) {
                logical.append(' ');
            }
            logical.append(s.text);
            pendingSpace = true;
        }
        this.emitLine(logical.toString(), true);
        return null;
    }

    @Override
    public Void visitInfoDir(PreprocessorParser.InfoDirContext ctx) {
        System.out.println(this.getLocation() + ":INFO:" + this.applyPlaceholders(ctx.INFO_TEXT().getText().trim()));
        return null;
    }

    @Override
    public Void visitErrorDir(PreprocessorParser.ErrorDirContext ctx) {
        System.err.println(this.getLocation() + ":ERROR: " + this.applyPlaceholders(ctx.INFO_TEXT().getText().trim()));
        this.hasErrors = true;
        System.exit(1);
        return null;
    }

    @Override
    public Void visitIncludeDir(PreprocessorParser.IncludeDirContext ctx) {
        String raw;
        boolean isSystem;
        boolean bl = isSystem = ctx.ANGLE_PATH() != null;
        if (isSystem) {
            raw = ctx.ANGLE_PATH().getText();
        } else if (ctx.STRING() != null) {
            raw = PreprocessorVisitor.stripQuotes(ctx.STRING().getText());
        } else {
            throw new PreprocessorException("Invalid #include; expected <path> or \"path\" at line " + ctx.getStart().getLine() + ": " + ctx.getText());
        }
        String path = PreprocessorVisitor.normalizeIncludeTarget(raw);
        if (!this.previouslyIncluded.contains(path)) {
            try {
                this.previouslyIncluded.add(path);
                String included = this.includeLoader.load(path, isSystem);
                Path filename = Path.of(path, new String[0]).getFileName();
                this.emitLine(filename.toString().replace("/", "$").replace(".", "$") + ":", false);
                PreprocessorVisitor pp = new PreprocessorVisitor(filename.toString(), this.includeLoader);
                String preprocessed = pp.preprocessText(included, this.defines, this.macros, this.previouslyIncluded, this.substituteInsideDirectives, 0);
                this.hasErrors |= pp.hasErrors();
                this.out.append(preprocessed);
            }
            catch (IllegalArgumentException ex) {
                throw new PreprocessorException(ex);
            }
        }
        return null;
    }

    @Override
    public Void visitDefineDir(PreprocessorParser.DefineDirContext ctx) {
        String name = ctx.id.getText();
        PreprocessorParser.LiteralContext lit = ctx.lit;
        if (lit != null) {
            if (lit.INT() != null) {
                this.addDefine(name, new DefVal(DefVal.Kind.INT, lit.INT().getText()));
            } else if (lit.FLOAT() != null) {
                this.addDefine(name, new DefVal(DefVal.Kind.FLOAT, lit.FLOAT().getText()));
            } else if (lit.CHAR() != null) {
                this.addDefine(name, new DefVal(DefVal.Kind.CHAR, lit.CHAR().getText()));
            } else if (lit.STRING() != null) {
                this.addDefine(name, new DefVal(DefVal.Kind.STRING, lit.STRING().getText()));
            } else if (lit.constExpr() != null) {
                this.addDefine(name, new DefVal(DefVal.Kind.EXPR, lit.constExpr().getText()));
            }
        } else if (ctx.symbol != null) {
            this.addDefine(name, new DefVal(DefVal.Kind.SYMBOL, ctx.symbol.getText()));
        } else {
            this.addDefine(name, new DefVal(DefVal.Kind.SYMBOL, "1"));
        }
        return null;
    }

    @Override
    public Void visitUndefDir(PreprocessorParser.UndefDirContext ctx) {
        String name = ctx.IDENT().getText();
        this.defines.remove(name);
        return null;
    }

    @Override
    public Void visitCallDir(PreprocessorParser.CallDirContext ctx) {
        if (ctx.argList() != null) {
            this.emitLineBeginDirective(this.filename, ctx);
            for (PreprocessorParser.CallArgContext param : ctx.argList().callArg().reversed()) {
                this.emitLine("push " + param.getText(), true);
            }
        }
        this.emitLine("call " + ctx.IDENT().getText(), true);
        if (ctx.argList() != null) {
            this.emitLine("add sp, " + ctx.argList().callArg().size(), true);
            this.emitLineEndDirective();
        }
        return null;
    }

    @Override
    public Void visitGlobalDir(PreprocessorParser.GlobalDirContext ctx) {
        String codeline = Utils.rebuildWithSingleSpaces(this.tokens, ctx.codeLine());
        PreprocessorVisitor pp = new PreprocessorVisitor(this.filename, this.sourceLineNum, this.includeLoader);
        ++this.pauseLineSync;
        codeline = pp.preprocessText(codeline, this.defines, this.macros, this.previouslyIncluded, true, this.pauseLineSync);
        --this.pauseLineSync;
        this.hasErrors |= pp.hasErrors();
        globals.add(String.format(".LINE \u00ab%s\u00bb, %d", this.filename, this.sourceLineNum));
        globals.add(codeline.trim());
        return null;
    }

    public static List<String> getGlobals() {
        return globals;
    }

    public static void resetGlobals() {
        globals.clear();
        sourceLocations.clear();
        preprocessedLineNum = 1;
    }

    public static String addGlobals(String preprocessed, boolean hasMain) {
        preprocessed = ".org 1" + System.lineSeparator() + "__CODE__: READONLY __CODE_END__" + System.lineSeparator() + (String)(hasMain ? "jump __MAIN__" + System.lineSeparator() : "") + (String)preprocessed + System.lineSeparator() + "__CODE_END__:" + System.lineSeparator() + "__DATA__:" + System.lineSeparator() + String.join((CharSequence)System.lineSeparator(), PreprocessorVisitor.getGlobals()) + System.lineSeparator() + "__DATA_END__:" + System.lineSeparator() + "__HEAP_START__:" + System.lineSeparator();
        PreprocessorVisitor.resetGlobals();
        return preprocessed;
    }

    @Override
    public Void visitSvarDir(PreprocessorParser.SvarDirContext ctx) {
        if (ctx.identList().IDENT().size() == 0) {
            return null;
        }
        if (ctx.identList().IDENT().size() == 1) {
            this.emitLine("push 0", false);
            this.svarSet.add(ctx.identList().IDENT(0).getText());
            this.addVar(ctx.identList().IDENT(0).getText(), "sf[0]");
            return null;
        }
        int i = 0;
        for (TerminalNode ident : ctx.identList().IDENT()) {
            this.svarSet.add(ident.getText());
            this.addVar(ident.getText(), "sf[" + i + "]");
            --i;
        }
        this.emitLine("add sp, " + i, false);
        return null;
    }

    @Override
    public Void visitVarDir(PreprocessorParser.VarDirContext ctx) {
        if (ctx.identList().IDENT().size() == 0) {
            return null;
        }
        if (ctx.identList().IDENT().size() == 1) {
            this.emitLine("push r28", false);
            this.varSet.add(ctx.identList().IDENT(0).getText());
            this.addVar(ctx.identList().IDENT(0).getText(), "R28");
            return null;
        }
        int reg = 28;
        for (TerminalNode ident : ctx.identList().IDENT()) {
            this.varSet.add(ident.getText());
            this.addVar(ident.getText(), "R" + reg);
            --reg;
        }
        this.emitLine("save r" + (reg + 1) + ", r28", false);
        return null;
    }

    @Override
    public Void visitFvarDir(PreprocessorParser.FvarDirContext ctx) {
        if (ctx.identList().IDENT().size() == 0) {
            return null;
        }
        if (ctx.identList().IDENT().size() == 1) {
            this.emitLine("push F31", false);
            this.fvarSet.add(ctx.identList().IDENT(0).getText());
            this.addVar(ctx.identList().IDENT(0).getText(), "F31");
            return null;
        }
        int reg = 31;
        for (TerminalNode ident : ctx.identList().IDENT()) {
            this.fvarSet.add(ident.getText());
            this.addVar(ident.getText(), "F" + reg);
            --reg;
        }
        this.emitLine("save f" + (reg + 1) + ", f31", false);
        return null;
    }

    @Override
    public Void visitReturnDir(PreprocessorParser.ReturnDirContext ctx) {
        if (ctx.primary() != null) {
            this.emitLine("MOVE R0, " + ctx.primary().getText(), this.substituteInsideDirectives);
            this.emitLine("JUMP " + this.funcName + "$_RETURN", false);
        }
        return null;
    }

    @Override
    public Void visitFreturnDir(PreprocessorParser.FreturnDirContext ctx) {
        if (ctx.primary() != null) {
            this.emitLine("MOVE F0, " + ctx.primary().getText(), this.substituteInsideDirectives);
            this.emitLine("JUMP " + this.funcName + "$_RETURN", false);
        }
        return null;
    }

    @Override
    public Void visitDefFuncDir(PreprocessorParser.DefFuncDirContext ctx) {
        this.funcName = "";
        for (ParseTree child : ctx.children) {
            if (child == ctx.PP_DEF_FUNC()) {
                this.svarSet.clear();
                this.fvarSet.clear();
                this.varSet.clear();
                this.pushScope();
                this.funcName = ctx.IDENT().getText().toUpperCase();
                this.emitLine(this.funcName + ":", false);
                if (ctx.paramList() != null) {
                    int i = 3;
                    for (TerminalNode arg : ctx.paramList().IDENT()) {
                        this.addVar(arg.getText(), "SF[" + i + "]");
                        ++i;
                    }
                }
                this.emitLine(".BLOCK _" + this.funcName, false);
                continue;
            }
            if (child == ctx.PP_END_FUNC()) {
                this.emitLineBeginDirective(this.filename, child);
                this.emitLine(this.funcName + "$_RETURN:", false);
                if (this.fvarSet.size() > 1) {
                    this.emitLine("restore f" + (31 - this.fvarSet.size() + 1) + ", f31", false);
                } else if (this.fvarSet.size() == 1) {
                    this.emitLine("pop f31", false);
                }
                if (this.varSet.size() > 1) {
                    this.emitLine("restore r" + (28 - this.varSet.size() + 1) + ", r28", false);
                } else if (this.varSet.size() == 1) {
                    this.emitLine("pop r28", false);
                }
                if (this.svarSet.size() > 0) {
                    this.emitLine("add sp, " + this.svarSet.size(), false);
                }
                this.emitLine("return", false);
                this.emitLine(".BLOCK_END _" + this.funcName, false);
                this.emitLineEndDirective();
                this.popScope();
                this.funcName = "";
                continue;
            }
            child.accept(this);
        }
        return null;
    }

    @Override
    public Void visitDefMacroDir(PreprocessorParser.DefMacroDirContext ctx) {
        this.macroDefName = ctx.IDENT().getText().toUpperCase();
        ArrayList<String> params = new ArrayList<String>();
        if (ctx.paramList() != null) {
            for (TerminalNode id : ctx.paramList().IDENT()) {
                params.add(id.getText().toUpperCase());
            }
        }
        if (ctx.paramList().ELLIPSIS() != null) {
            params.add("...");
        }
        StringBuilder body = new StringBuilder();
        if (ctx.block().children != null) {
            for (ParseTree child : ctx.block().children) {
                String s = Utils.rebuildWithSingleSpaces(this.tokens, child);
                if (s.length() <= 0) continue;
                body.append(s);
                body.append('\n');
            }
        }
        this.macros.put(this.macroDefName, Pair.of(params, body.toString()));
        return null;
    }

    @Override
    public Void visitMacroDir(PreprocessorParser.MacroDirContext ctx) {
        String replacement;
        Pair<List<String>, String> def = this.macros.get(ctx.IDENT().getText().toUpperCase());
        if (def != null) {
            HashMap<String, String> formalParams = new HashMap<String, String>();
            ArrayList<String> varArgs = new ArrayList<String>();
            for (int i = 0; i < def.getLeft().size(); ++i) {
                if (def.getLeft().get(i).equals("...")) {
                    for (int j = i; j < ctx.argList().callArg().size(); ++j) {
                        varArgs.add(ctx.argList().callArg(j).getText());
                    }
                    formalParams.put("...", String.join((CharSequence)", ", varArgs));
                    break;
                }
                formalParams.put(def.getLeft().get(i).toUpperCase(), ctx.argList().callArg(i).getText());
            }
            replacement = this.applyPlaceholders(def.getRight(), formalParams);
            this.emitLineBeginDirective(this.filename, ctx);
            if (this.pauseLineSync > 10) {
                throw new PreprocessorException("Macro nesting exceeded 10 levels!");
            }
            PreprocessorVisitor pp = new PreprocessorVisitor(this.filename, this.sourceLineNum, this.includeLoader);
            replacement = pp.preprocessText(replacement, this.defines, this.macros, this.previouslyIncluded, true, this.pauseLineSync);
            this.hasErrors |= pp.hasErrors();
        } else {
            throw new PreprocessorException("Undefined macro: " + ctx.IDENT().getText());
        }
        this.emitLine(replacement, true);
        this.emitLineEndDirective();
        return null;
    }

    @Override
    public Void visitIfBlock(PreprocessorParser.IfBlockContext ctx) {
        if (this.evalExpr(ctx.expr()) && ctx.block() != null) {
            this.visit(ctx.block());
            return null;
        }
        for (PreprocessorParser.ElseifClauseContext elif : ctx.elseifClause()) {
            if (!this.evalExpr(elif.expr()) || elif.block() == null) continue;
            this.visit(elif.block());
            return null;
        }
        if (ctx.elseClause() != null && ctx.elseClause().block() != null) {
            this.visit(ctx.elseClause().block());
        }
        return null;
    }

    @Override
    public Void visitIfDefBlock(PreprocessorParser.IfDefBlockContext ctx) {
        if (ctx.primary() != null) {
            boolean b;
            boolean bl = b = ctx.primary().IDENT() != null ? this.defines.containsKey(ctx.primary().IDENT().getText().toUpperCase()) : true;
            if (b) {
                this.visit(ctx.block());
                return null;
            }
            if (ctx.elseClause() != null && ctx.elseClause().block() != null) {
                this.visit(ctx.elseClause().block());
            }
        }
        return null;
    }

    @Override
    public Void visitIfNDefBlock(PreprocessorParser.IfNDefBlockContext ctx) {
        if (ctx.primary() != null) {
            boolean b;
            boolean bl = b = ctx.primary().IDENT() != null ? this.defines.containsKey(ctx.primary().IDENT().getText().toUpperCase()) : true;
            if (!b) {
                this.visit(ctx.block());
                return null;
            }
            if (ctx.elseClause() != null && ctx.elseClause().block() != null) {
                this.visit(ctx.elseClause().block());
            }
        }
        return null;
    }

    private String getConditionCode(String s) {
        String result = null;
        switch (s.toUpperCase()) {
            case "==": 
            case "EQ": {
                result = "z";
                break;
            }
            case "!=": 
            case "NE": {
                result = "nz";
                break;
            }
            case "<": 
            case "LT": {
                result = "n";
                break;
            }
            case "<=": 
            case "LE": {
                result = "np";
                break;
            }
            case ">": 
            case "GT": {
                result = "p";
                break;
            }
            case ">=": 
            case "GE": {
                result = "nn";
                break;
            }
            default: {
                throw new PreprocessorException("Illegal loop expression");
            }
        }
        return result;
    }

    private String getNotConditionCode(String s) {
        String result = null;
        switch (s.toUpperCase()) {
            case "==": 
            case "EQ": 
            case "Z": {
                result = "nz";
                break;
            }
            case "!=": 
            case "NE": 
            case "NZ": {
                result = "z";
                break;
            }
            case "<": 
            case "LT": 
            case "N": {
                result = "nn";
                break;
            }
            case "<=": 
            case "LE": 
            case "NP": {
                result = "p";
                break;
            }
            case ">": 
            case "GT": 
            case "P": {
                result = "np";
                break;
            }
            case ">=": 
            case "GE": 
            case "NN": {
                result = "n";
                break;
            }
            case "PE": {
                result = "po";
                break;
            }
            case "PO": {
                result = "pe";
                break;
            }
            case "O": {
                result = "no";
                break;
            }
            case "NO": {
                result = "o";
                break;
            }
            default: {
                throw new PreprocessorException("Illegal loop/cond expression");
            }
        }
        return result;
    }

    @Override
    public Void visitForBlock(PreprocessorParser.ForBlockContext ctx) {
        String loopVar;
        if (ctx.cond != null && ctx.block() != null) {
            String blockName = "FOR_{}";
            this.emitLineBeginDirective(this.filename, ctx);
            this.emitLine(".BLOCK " + blockName, false);
            loopVar = ctx.cond.primary(0).getText();
            if (ctx.init != null) {
                this.emitLine("move " + loopVar + ", " + ctx.init.getText(), true);
            }
            this.emitLine("jump $_LOOP_TEST", true);
            this.emitLine("$_LOOP_BEGIN:", true);
            this.emitLineEndDirective();
            this.visit(ctx.block());
            this.emitLineBeginDirective(this.filename, ctx.PP_ENDFOR());
            this.emitLine("$_LOOP_NEXT:", true);
            if (ctx.incr != null) {
                this.emitLine("add " + loopVar + ", " + ctx.incr.getText(), true);
            }
        } else {
            throw new PreprocessorException("For loop needs an expression and a block!");
        }
        this.emitLine("$_LOOP_TEST:", true);
        this.emitLine("cmp " + loopVar + ", " + ctx.cond.primary(1).getText(), true);
        String conditionOp = this.getConditionCode(ctx.cond.cmpOp().getText());
        this.emitLine("jump " + conditionOp + ", $_LOOP_BEGIN", false);
        this.emitLine("$_LOOP_END:", true);
        this.emitLine(".BLOCK_END", false);
        this.emitLineEndDirective();
        return null;
    }

    @Override
    public Void visitWhileBlock(PreprocessorParser.WhileBlockContext ctx) {
        if (ctx.cond != null && ctx.block() != null) {
            String blockName = "WHILE_{}";
            this.emitLineBeginDirective(this.filename, ctx);
            this.emitLine(".BLOCK " + blockName, false);
            String loopVar = ctx.cond.primary(0).getText();
            this.emitLine("jump $_LOOP_TEST", true);
            this.emitLine("$_LOOP_BEGIN:", true);
            this.emitLineEndDirective();
            this.visit(ctx.block());
            this.emitLineBeginDirective(this.filename, ctx.PP_ENDWHILE());
            this.emitLine("$_LOOP_NEXT:", true);
            this.emitLine("$_LOOP_TEST:", true);
            if (ctx.cond.primary().size() == 1) {
                loopVar = this.applyDefines(loopVar);
                try {
                    long i = Long.parseLong(loopVar);
                    if (i != 0L) {
                        this.emitLine("jump $_LOOP_BEGIN", false);
                    }
                }
                catch (NumberFormatException e) {
                    this.emitLine("test " + loopVar, false);
                    this.emitLine("jump nz, $_LOOP_BEGIN", false);
                }
            } else {
                this.emitLine("cmp " + loopVar + ", " + ctx.cond.primary(1).getText(), true);
                String conditionOp = this.getConditionCode(ctx.cond.cmpOp().getText());
                this.emitLine("jump " + conditionOp + ", $_LOOP_BEGIN", false);
            }
        } else {
            throw new PreprocessorException("For loop needs an expression and a block!");
        }
        this.emitLine("$_LOOP_END:", true);
        this.emitLine(".BLOCK_END", false);
        this.emitLineEndDirective();
        return null;
    }

    @Override
    public Void visitDoWhileBlock(PreprocessorParser.DoWhileBlockContext ctx) {
        if (ctx.cond != null && ctx.block() != null) {
            String blockName = "DO_WHILE_{}";
            this.emitLineBeginDirective(this.filename, ctx);
            this.emitLine(".BLOCK " + blockName, false);
            String loopVar = ctx.cond.primary(0).getText();
            this.emitLine("$_LOOP_BEGIN:", true);
            this.emitLineEndDirective();
            this.visit(ctx.block());
            this.emitLineBeginDirective(this.filename, ctx.PP_ENDDOWHILE());
            this.emitLine("$_LOOP_NEXT:", true);
            this.emitLine("$_LOOP_TEST:", true);
            if (ctx.cond.primary().size() == 1) {
                loopVar = this.applyDefines(loopVar);
                try {
                    long i = Long.parseLong(loopVar);
                    if (i != 0L) {
                        this.emitLine("jump $_LOOP_BEGIN", false);
                    }
                }
                catch (NumberFormatException e) {
                    this.emitLine("test " + loopVar, false);
                    this.emitLine("jump nz, $_LOOP_BEGIN", false);
                }
            } else {
                this.emitLine("cmp " + loopVar + ", " + ctx.cond.primary(1).getText(), true);
                String conditionOp = this.getConditionCode(ctx.cond.cmpOp().getText());
                this.emitLine("jump " + conditionOp + ", $_LOOP_BEGIN", false);
            }
        } else {
            throw new PreprocessorException("For loop needs an expression and a block!");
        }
        this.emitLine("$_LOOP_END:", true);
        this.emitLine(".BLOCK_END", false);
        this.emitLineEndDirective();
        return null;
    }

    @Override
    public Void visitBreakDir(PreprocessorParser.BreakDirContext ctx) {
        this.emitLine("JUMP $$_LOOP_END", true);
        return null;
    }

    @Override
    public Void visitContinueDir(PreprocessorParser.ContinueDirContext ctx) {
        this.emitLine("JUMP $$_LOOP_NEXT", true);
        return null;
    }

    @Override
    public Void visitIfCondBlock(PreprocessorParser.IfCondBlockContext ctx) {
        if (ctx.cond != null && ctx.block() != null) {
            String conditionOp;
            String rightVal;
            String blockName = "COND_{}";
            this.emitLineBeginDirective(this.filename, ctx);
            this.emitLine(".BLOCK " + blockName, false);
            String leftVal = ctx.cond.primary(0).getText();
            if (ctx.cond.primary().size() == 2) {
                rightVal = ctx.cond.primary(1).getText();
                conditionOp = this.getNotConditionCode(ctx.cond.cmpOp().getText());
                this.emitLine("cmp " + leftVal + ", " + rightVal, true);
                this.emitLine("jump " + conditionOp + ", $_SKIP", false);
            } else {
                leftVal = this.applyDefines(leftVal);
                try {
                    long v = Long.parseLong(leftVal);
                    if (v == 0L) {
                        this.emitLine("jump $_SKIP", false);
                    }
                }
                catch (NumberFormatException e) {
                    this.emitLine("test " + leftVal, false);
                    this.emitLine("jump z, $_SKIP", false);
                }
            }
            this.emitLineEndDirective();
            this.visit(ctx.block());
            if (ctx.elseCondClause() != null || ctx.elseifCondClause().size() > 0) {
                this.emitLineDirective(this.filename, ctx.elseifCondClause().size() > 0 ? ctx.elseifCondClause(0) : ctx.elseCondClause());
                this.emitLine("jump $_COND_END", false);
            }
            this.emitLine("$_SKIP:", false);
            if (ctx.elseifCondClause() != null) {
                for (int i = 0; i < ctx.elseifCondClause().size(); ++i) {
                    PreprocessorParser.ElseifCondClauseContext ectx = ctx.elseifCondClause(i);
                    this.emitLineBeginDirective(this.filename, ectx);
                    leftVal = ectx.cond.primary(0).getText();
                    if (ctx.cond.primary().size() == 2) {
                        rightVal = ectx.cond.primary(1).getText();
                        conditionOp = this.getNotConditionCode(ectx.cond.cmpOp().getText());
                        this.emitLine("cmp " + leftVal + ", " + rightVal, true);
                        this.emitLine("jump " + conditionOp + ", $_SKIP_" + (i + 1), false);
                    } else {
                        leftVal = this.applyDefines(leftVal);
                        try {
                            long v = Long.parseLong(leftVal);
                            if (v == 0L) {
                                this.emitLine("jump $_SKIP_" + (i + 1), false);
                            }
                        }
                        catch (NumberFormatException e) {
                            this.emitLine("test " + leftVal, false);
                            this.emitLine("jump z, $_SKIP_" + (i + 1), false);
                        }
                    }
                    this.emitLineEndDirective();
                    this.visit(ectx.block());
                    if (ctx.elseCondClause() != null || i < ctx.elseifCondClause().size() - 1) {
                        this.emitLineDirective(this.filename, ctx.elseifCondClause((int)i).stop, 1);
                        this.emitLine("jump $_COND_END", false);
                    }
                    this.emitLine("$_SKIP_" + (i + 1) + ":", false);
                }
            }
            if (ctx.elseCondClause() != null) {
                this.visit(ctx.elseCondClause().block());
            }
        } else {
            throw new PreprocessorException("If condition needs an expression and a block!");
        }
        this.emitLineBeginDirective(this.filename, ctx.PP_ENDCOND());
        this.emitLine("$_COND_END:", false);
        this.emitLine(".BLOCK_END", false);
        this.emitLineEndDirective();
        return null;
    }

    @Override
    public Void visitIfCondSRBlock(PreprocessorParser.IfCondSRBlockContext ctx) {
        if ((ctx.IDENT() != null || ctx.cmpOp() != null) && ctx.block() != null) {
            String blockName = "CONDSR_{}";
            this.emitLineBeginDirective(this.filename, ctx);
            this.emitLine(".BLOCK " + blockName, false);
            String conditionOp = "x";
            conditionOp = ctx.IDENT() != null ? ctx.IDENT().getText().toUpperCase() : ctx.cmpOp().getText().toUpperCase();
            if (!conditionOp.matches("Z|NZ|N|P|NN|NP|PE|PO|O|NO|EQ|NE|LT|GT|GE|LE")) {
                throw new PreprocessorException("If condition SR IDENT must be one of: z, nz, n, p, nn, np, pe, po, o, no");
            }
            this.emitLine("jump " + this.getNotConditionCode(conditionOp) + ", $_SKIP", false);
            this.emitLineEndDirective();
            this.visit(ctx.block());
            if (ctx.elseCondClause() != null) {
                this.emitLineDirective(this.filename, ctx.elseCondClause());
                this.emitLine("jump $_COND_END", false);
            }
            this.emitLine("$_SKIP:", false);
            if (ctx.elseCondClause() != null) {
                this.visit(ctx.elseCondClause().block());
            }
        } else {
            throw new PreprocessorException("If condition SR needs an SR code and a block!");
        }
        this.emitLineBeginDirective(this.filename, ctx.PP_ENDCOND());
        this.emitLine("$_COND_END:", false);
        this.emitLine(".BLOCK_END", false);
        this.emitLineEndDirective();
        return null;
    }

    @Override
    public Void visitSyncBlock(PreprocessorParser.SyncBlockContext ctx) {
        String mutex;
        if (ctx.IDENT() != null && ctx.block() != null) {
            String blockName = "SYNC_{}";
            mutex = ctx.IDENT(0).getText().toUpperCase();
            this.emitLineBeginDirective(this.filename, ctx);
            this.emitLine(".BLOCK " + blockName, false);
            if (ctx.offset != null) {
                this.emitLine("move r0, " + mutex + "[" + ctx.offset.getText() + "]", true);
                this.emitLine("push r0", true);
            } else {
                this.emitLine("push " + mutex, true);
            }
        } else {
            throw new PreprocessorException("Sync block needs a mutex and a block!");
        }
        this.emitLine("call acquireMutex", false);
        this.emitLine("add sp, 1", false);
        this.emitLineEndDirective();
        this.visit(ctx.block());
        this.emitLineBeginDirective(this.filename, ctx.PP_ENDSYNC());
        this.emitLine("push " + mutex, true);
        this.emitLine("call releaseMutex", false);
        this.emitLine("add sp, 1", false);
        this.emitLine(".BLOCK_END", false);
        this.emitLineEndDirective();
        return null;
    }

    @Override
    public Void visitBlock(PreprocessorParser.BlockContext ctx) {
        if (ctx.children == null) {
            return null;
        }
        for (ParseTree child : ctx.children) {
            child.accept(this);
        }
        return null;
    }

    private boolean evalExpr(PreprocessorParser.ExprContext expr) {
        PreprocessorParser.PrimaryContext p0 = expr.primary(0);
        if (expr.cmpOp() == null) {
            return this.truthy(p0);
        }
        PreprocessorParser.PrimaryContext p1 = expr.primary(1);
        String op = expr.cmpOp().getText();
        return this.compare(p0, op, p1);
    }

    private boolean truthy(PreprocessorParser.PrimaryContext p) {
        if (p.IDENT() != null) {
            String name = p.IDENT().getText();
            DefVal dv = this.defines.get(name);
            if (dv == null) {
                return false;
            }
            switch (dv.kind.ordinal()) {
                case 0: {
                    return PreprocessorVisitor.parseLongSafe(dv.text) != 0L;
                }
                case 1: {
                    return Double.compare(PreprocessorVisitor.parseDoubleSafe(dv.text), 0.0) != 0;
                }
                case 2: {
                    return PreprocessorVisitor.charValue(dv.text) != 0;
                }
                case 3: {
                    return PreprocessorVisitor.stripQuotes(dv.text).length() != 0;
                }
                case 5: {
                    return true;
                }
            }
        } else if (p.literal() != null) {
            return this.literalTruthy(p.literal());
        }
        return false;
    }

    private boolean compare(PreprocessorParser.PrimaryContext a, String op, PreprocessorParser.PrimaryContext b) {
        if (this.isNumericLike(a) && this.isNumericLike(b)) {
            double da = this.asDouble(a);
            double db = this.asDouble(b);
            switch (op) {
                case "==": {
                    return da == db;
                }
                case "!=": {
                    return da != db;
                }
                case "<": {
                    return da < db;
                }
                case "<=": {
                    return da <= db;
                }
                case ">": {
                    return da > db;
                }
                case ">=": {
                    return da >= db;
                }
            }
        } else {
            String sa = this.asString(a);
            String sb = this.asString(b);
            int cmp = sa.compareTo(sb);
            switch (op) {
                case "==": {
                    return cmp == 0;
                }
                case "!=": {
                    return cmp != 0;
                }
                case "<": {
                    return cmp < 0;
                }
                case "<=": {
                    return cmp <= 0;
                }
                case ">": {
                    return cmp > 0;
                }
                case ">=": {
                    return cmp >= 0;
                }
            }
        }
        throw new PreprocessorException("Unsupported compare op: " + op);
    }

    private boolean isNumericLike(PreprocessorParser.PrimaryContext p) {
        if (p.literal() != null) {
            return p.literal().INT() != null || p.literal().FLOAT() != null || p.literal().CHAR() != null;
        }
        if (p.IDENT() != null) {
            DefVal dv = this.defines.get(p.IDENT().getText());
            if (dv == null) {
                return false;
            }
            return dv.kind == DefVal.Kind.INT || dv.kind == DefVal.Kind.FLOAT || dv.kind == DefVal.Kind.CHAR;
        }
        return false;
    }

    private double asDouble(PreprocessorParser.PrimaryContext p) {
        if (p.literal() != null) {
            if (p.literal().INT() != null) {
                return PreprocessorVisitor.parseLongSafe(p.literal().INT().getText());
            }
            if (p.literal().FLOAT() != null) {
                return PreprocessorVisitor.parseDoubleSafe(p.literal().FLOAT().getText());
            }
            if (p.literal().CHAR() != null) {
                return PreprocessorVisitor.charValue(p.literal().CHAR().getText());
            }
        }
        if (p.IDENT() != null) {
            DefVal dv = this.defines.get(p.IDENT().getText());
            if (dv == null) {
                return 0.0;
            }
            switch (dv.kind.ordinal()) {
                case 0: {
                    return PreprocessorVisitor.parseLongSafe(dv.text);
                }
                case 1: {
                    return PreprocessorVisitor.parseDoubleSafe(dv.text);
                }
                case 2: {
                    return PreprocessorVisitor.charValue(dv.text);
                }
            }
            return 0.0;
        }
        return 0.0;
    }

    private String asString(PreprocessorParser.PrimaryContext p) {
        if (p.literal() != null) {
            if (p.literal().STRING() != null) {
                return PreprocessorVisitor.stripQuotes(p.literal().STRING().getText());
            }
            if (p.literal().CHAR() != null) {
                return new String(new char[]{(char)PreprocessorVisitor.charValue(p.literal().CHAR().getText())});
            }
            return p.literal().getText();
        }
        if (p.IDENT() != null) {
            DefVal dv = this.defines.get(p.IDENT().getText());
            return dv == null ? "" : dv.text;
        }
        return "";
    }

    private boolean literalTruthy(PreprocessorParser.LiteralContext lit) {
        if (lit.INT() != null) {
            return PreprocessorVisitor.parseLongSafe(lit.INT().getText()) != 0L;
        }
        if (lit.FLOAT() != null) {
            return Double.compare(PreprocessorVisitor.parseDoubleSafe(lit.FLOAT().getText()), 0.0) != 0;
        }
        if (lit.CHAR() != null) {
            return PreprocessorVisitor.charValue(lit.CHAR().getText()) != 0;
        }
        if (lit.STRING() != null) {
            return PreprocessorVisitor.stripQuotes(lit.STRING().getText()).length() != 0;
        }
        return false;
    }

    private void emitLine(String s, boolean doSubst) {
        if (!this.lineDirectives.isEmpty()) {
            this.out.append(this.lineDirectives.pop());
            this.lineDirectives.clear();
            ++preprocessedLineNum;
        }
        if (doSubst) {
            s = this.applyDefines(s);
        }
        if (s.length() != 0) {
            sourceLocations.put(preprocessedLineNum, String.format("\u00ab%s\u00bb:%d", this.filename, this.sourceLineNum));
            ExpressionFolder folder = new ExpressionFolder(this.filename, this.sourceLineNum);
            s = folder.fold(s);
            ++preprocessedLineNum;
            this.out.append(s);
            if (s.charAt(s.length() - 1) != '\n') {
                this.out.append('\n');
            }
        }
        if (this.pauseLineSync <= 0) {
            ++this.sourceLineNum;
        }
    }

    private void emitLineDirective(String filename, ParseTree ctx) {
        if (this.pauseLineSync <= 0) {
            this.sourceLineNum = PreprocessorVisitor.lineOf(ctx);
            this.lineDirectives.push(String.format(".LINE \u00ab%s\u00bb, %d%n", filename, this.sourceLineNum));
        }
    }

    private void emitLineDirective(String filename, Token tok, int additional) {
        if (this.pauseLineSync <= 0) {
            this.sourceLineNum = tok.getLine() + 1;
            this.lineDirectives.push(String.format(".LINE \u00ab%s\u00bb, %d%n", filename, this.sourceLineNum));
        }
    }

    private void emitLineBeginDirective(String filename, ParseTree ctx) {
        this.lineDirectives.clear();
        ++this.pauseLineSync;
        if (this.pauseLineSync <= 1) {
            this.sourceLineNum = PreprocessorVisitor.lineOf(ctx);
            this.emitLine(String.format(".LINE_BEGIN \u00ab%s\u00bb, %d", filename, this.sourceLineNum), false);
        }
    }

    private void emitLineEndDirective() {
        --this.pauseLineSync;
        if (this.pauseLineSync <= 0) {
            this.emitLine(".LINE_END", false);
        }
    }

    private String applyDefines(String line) {
        if (line.isEmpty()) {
            return line;
        }
        Matcher m = TOKEN.matcher(line);
        StringBuffer sb = new StringBuffer(line.length());
        while (m.find()) {
            int start = m.start();
            if (PreprocessorVisitor.isInsideQuotes(line, start)) {
                m.appendReplacement(sb, m.group());
                continue;
            }
            String ident = m.group().toUpperCase();
            Object replacement = null;
            DefVal dv = this.defines.get(ident);
            if (dv != null) {
                replacement = dv.text;
            } else {
                replacement = this.lookupVar(ident);
                if (replacement == null) {
                    if (ident.equals("__FILE__")) {
                        replacement = "\"" + this.filename + "\"";
                    } else {
                        if (!ident.equals("__LINE__")) continue;
                        replacement = String.valueOf(this.sourceLineNum);
                    }
                }
            }
            replacement = ((String)replacement).replace("\\", "\\\\").replace("$", "\\$");
            m.appendReplacement(sb, (String)replacement);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private static boolean isInsideQuotes(String s, int pos) {
        boolean inSingle = false;
        boolean inDouble = false;
        boolean escaped = false;
        for (int i = 0; i < pos; ++i) {
            char c = s.charAt(i);
            if (escaped) {
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == '\'' && !inDouble) {
                inSingle = !inSingle;
                continue;
            }
            if (c != '\"' || inSingle) continue;
            inDouble = !inDouble;
        }
        return inSingle || inDouble;
    }

    private String applyPlaceholders(String line, Map<String, String> formalArgs) {
        if (line.isEmpty()) {
            return line;
        }
        Matcher m = PLACEHOLDER.matcher(line);
        StringBuffer sb = new StringBuffer(line.length());
        while (m.find()) {
            String ident = m.group(1).toUpperCase();
            String replacement = formalArgs.get(ident);
            if (replacement == null) continue;
            replacement = replacement.replace("\\", "\\\\").replace("$", "\\$");
            m.appendReplacement(sb, replacement);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private String applyPlaceholders(String line) {
        if (line.isEmpty()) {
            return line;
        }
        Matcher m = PLACEHOLDER.matcher(line);
        StringBuffer sb = new StringBuffer(line.length());
        while (m.find()) {
            String ident = m.group(1).toUpperCase();
            String replacement = this.defines.get((Object)ident).text;
            if (replacement == null) continue;
            replacement = replacement.replace("\\", "\\\\").replace("$", "\\$");
            m.appendReplacement(sb, replacement);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public DefVal getDefine(String symbol) {
        DefVal dv = this.defines.get(symbol);
        return dv;
    }

    private static long parseLongSafe(String s) {
        try {
            return Long.decode(s);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private static double parseDoubleSafe(String s) {
        try {
            return Double.parseDouble(s);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    private static int charValue(String charToken) {
        if (charToken.length() >= 3 && charToken.charAt(0) == '\'' && charToken.charAt(charToken.length() - 1) == '\'') {
            String body = charToken.substring(1, charToken.length() - 1);
            if (body.startsWith("\\u") && body.length() == 6) {
                return Integer.parseInt(body.substring(2), 16);
            }
            if (body.startsWith("\\")) {
                switch (body) {
                    case "\\n": {
                        return 10;
                    }
                    case "\\r": {
                        return 13;
                    }
                    case "\\t": {
                        return 9;
                    }
                    case "\\f": {
                        return 12;
                    }
                    case "\\b": {
                        return 8;
                    }
                    case "\\'": {
                        return 39;
                    }
                    case "\\\"": {
                        return 34;
                    }
                    case "\\\\": {
                        return 92;
                    }
                }
                return body.charAt(body.length() - 1);
            }
            return body.isEmpty() ? 0 : (int)body.charAt(0);
        }
        return 0;
    }

    private static String stripQuotes(String s) {
        if (s != null && s.length() >= 2 && s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    private static String normalizeIncludeTarget(String raw) {
        if (raw == null) {
            return null;
        }
        if (raw.startsWith("<") && raw.endsWith(">")) {
            return raw.substring(1, raw.length() - 1).trim();
        }
        return raw;
    }

    public String preprocessText(String source) {
        return this.preprocessText(source, null, null, null, true, 0);
    }

    public String preprocessText(String source, String[] args) {
        HashMap<String, DefVal> definitions = new HashMap<String, DefVal>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.charAt(0) != '-') continue;
            if (arg.equals("--DEBUG")) {
                definitions.put("__DEBUG__", new DefVal(DefVal.Kind.SYMBOL, "1"));
                args[i] = null;
                continue;
            }
            if (!arg.startsWith("-D")) continue;
            String[] def = arg.substring(2).split("=", 2);
            if (def.length == 2) {
                definitions.put(def[0], new DefVal(DefVal.Kind.STRING, def[1]));
            } else {
                definitions.put(def[0], new DefVal(DefVal.Kind.SYMBOL, "1"));
            }
            args[i] = null;
        }
        return this.preprocessText(source, definitions, null, null, true, 0);
    }

    public String preprocessText(String source, Map<String, DefVal> seedDefines, Map<String, Pair<List<String>, String>> seedMacros, Set<String> seedIncludes, boolean substituteInsideDirectives, int pauseLineSync) {
        if (!((String)source).endsWith("\n")) {
            source = (String)source + System.lineSeparator();
        }
        CodePointCharStream input = CharStreams.fromString((String)source);
        PreprocessorLexer lexer = new PreprocessorLexer(input);
        lexer.removeErrorListeners();
        lexer.addErrorListener(new PreprocessorErrorListener(this.filename));
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        PreprocessorParser parser = new PreprocessorParser(tokens);
        parser.removeErrorListeners();
        parser.addErrorListener(new PreprocessorErrorListener(this.filename));
        PreprocessorVisitor v = new PreprocessorVisitor(this.filename, this.sourceLineNum, this.includeLoader);
        v.setTokens(tokens);
        v.defines = seedDefines != null ? seedDefines : new HashMap();
        v.macros = seedMacros != null ? seedMacros : new HashMap();
        v.substituteInsideDirectives = substituteInsideDirectives;
        v.pauseLineSync = pauseLineSync;
        v.previouslyIncluded = seedIncludes != null ? seedIncludes : new HashSet();
        v.visit(parser.preproc());
        String preprocessed = v.getOutput();
        if (v.hasErrors()) {
            throw new RuntimeException("Too many preprocessor errors!");
        }
        return preprocessed;
    }

    public static interface IncludeLoader {
        public String load(String var1, boolean var2);
    }

    public class PreprocessorException
    extends RuntimeException {
        PreprocessorException(String msg) {
            super(PreprocessorVisitor.this.getLocation() + ":ERROR:" + msg);
        }

        PreprocessorException(String msg, Object ... args) {
            super(String.format(PreprocessorVisitor.this.getLocation() + ":ERROR:" + msg, args));
        }

        PreprocessorException(Exception ex) {
            super(PreprocessorVisitor.this.getLocation() + ":ERROR:" + ex.getMessage());
        }
    }

    public static final class DefVal {
        public final Kind kind;
        public final String text;

        public DefVal(Kind kind, String text) {
            this.kind = kind;
            this.text = text;
        }

        public static enum Kind {
            INT,
            FLOAT,
            CHAR,
            STRING,
            EXPR,
            SYMBOL;

        }
    }

    final class PreprocessorErrorListener
    extends BaseErrorListener {
        private String filename;

        public PreprocessorErrorListener(String filename) {
            this.filename = filename;
        }

        @Override
        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            String where = String.format("\u00ab%s\u00bb:%d:%d", this.filename, PreprocessorVisitor.this.sourceLineNum, charPositionInLine);
            String sourceLine = "";
            Object tokenText = "";
            if (offendingSymbol instanceof Token) {
                Token t = (Token)offendingSymbol;
                tokenText = " near '" + t.getText() + "'";
                sourceLine = Utils.extractSourceLine(t);
            }
            System.err.println(where + ":PPERROR:" + msg);
            if (!sourceLine.isEmpty()) {
                System.err.println("    " + sourceLine);
                System.err.println("    " + " ".repeat(charPositionInLine) + "^");
            }
            PreprocessorVisitor.this.hasErrors = true;
        }
    }
}

