/*
 * Decompiled with CFR 0.152.
 */
package cloud.lesh.CPUSim64;

import cloud.lesh.CPUSim64.PortHandler;
import cloud.lesh.CPUSim64.Simulator;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Objects;

public class RawFilePortHandler
extends PortHandler {
    private FileOutputStream os;
    private FileInputStream is;
    private String filespec;

    public RawFilePortHandler(Simulator cpu, String filespec, int mode) throws Simulator.CPUException {
        super(cpu);
        this.filespec = filespec;
        try {
            switch (mode) {
                case 0: {
                    this.is = new FileInputStream(filespec);
                    break;
                }
                case 1: {
                    this.os = new FileOutputStream(filespec);
                    break;
                }
                case 2: {
                    this.os = new FileOutputStream(filespec, true);
                    break;
                }
                default: {
                    throw new Exception();
                }
            }
        }
        catch (Exception e) {
            Simulator simulator = cpu;
            Objects.requireNonNull(simulator);
            throw new Simulator.CPUException(simulator, "File open error on \"" + filespec + "\" using mode " + mode + "!");
        }
    }

    @Override
    public int read() throws Simulator.CPUException {
        if (this.is == null) {
            Simulator simulator = this.cpu;
            Objects.requireNonNull(simulator);
            throw new Simulator.CPUException(simulator, "File \"" + this.filespec + "\" not open for input!");
        }
        try {
            return this.is.read();
        }
        catch (Exception e) {
            Simulator simulator = this.cpu;
            Objects.requireNonNull(simulator);
            throw new Simulator.CPUException(simulator, "Read error on file \"" + this.filespec + "\"!");
        }
    }

    @Override
    public int readChar() throws Simulator.CPUException {
        Simulator simulator = this.cpu;
        Objects.requireNonNull(simulator);
        throw new Simulator.CPUException(simulator, "Can't read chars from raw file!");
    }

    @Override
    public void write(byte x) throws Simulator.CPUException {
        if (this.os == null) {
            Simulator simulator = this.cpu;
            Objects.requireNonNull(simulator);
            throw new Simulator.CPUException(simulator, "File \"" + this.filespec + "\" not open for output!");
        }
        try {
            this.os.write(x);
        }
        catch (Exception e) {
            Simulator simulator = this.cpu;
            Objects.requireNonNull(simulator);
            throw new Simulator.CPUException(simulator, "Write error on file \"" + this.filespec + "\"!");
        }
    }

    @Override
    public void writeChar(int x) throws Simulator.CPUException {
        Simulator simulator = this.cpu;
        Objects.requireNonNull(simulator);
        throw new Simulator.CPUException(simulator, "Can't write chars to raw file!");
    }

    @Override
    public void flush() throws Simulator.CPUException {
        if (this.os == null) {
            Simulator simulator = this.cpu;
            Objects.requireNonNull(simulator);
            throw new Simulator.CPUException(simulator, "File \"" + this.filespec + "\" not open for output!");
        }
        try {
            this.os.flush();
        }
        catch (Exception e) {
            Simulator simulator = this.cpu;
            Objects.requireNonNull(simulator);
            throw new Simulator.CPUException(simulator, "Flush error on file \"" + this.filespec + "\"!");
        }
    }

    @Override
    public void close() throws Simulator.CPUException {
        try {
            if (this.is != null) {
                this.is.close();
            }
            if (this.os != null) {
                this.os.close();
            }
            this.is = null;
            this.os = null;
        }
        catch (Exception e) {
            Simulator simulator = this.cpu;
            Objects.requireNonNull(simulator);
            throw new Simulator.CPUException(simulator, "Error closing file \"" + this.filespec + "\"!");
        }
    }
}

