/*
 * Decompiled with CFR 0.152.
 */
package cloud.lesh.CPUSim64;

import cloud.lesh.CPUSim64.CPUSim64BaseListener;
import cloud.lesh.CPUSim64.CPUSim64Parser;
import cloud.lesh.CPUSim64.Condition;
import cloud.lesh.CPUSim64.ConditionMapper;
import cloud.lesh.CPUSim64.SemanticError;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.TerminalNode;

public class SemanticsCheck
extends CPUSim64BaseListener {
    private final List<SemanticError> errors = new ArrayList<SemanticError>();

    public List<SemanticError> getErrors() {
        return this.errors;
    }

    private void err(Token t, String msg) {
        this.errors.add(new SemanticError(t.getLine(), t.getCharPositionInLine(), msg));
    }

    @Override
    public void visitTerminal(TerminalNode node) {
        Token t = node.getSymbol();
        switch (t.getType()) {
            case 47: {
                this.checkIntReg(t);
                break;
            }
            case 48: {
                this.checkFloatReg(t);
            }
        }
    }

    private void checkIntReg(Token t) {
        String s = t.getText().substring(1);
        try {
            int n = Integer.parseInt(s);
            if (n < 0 || n > 28) {
                this.err(t, "Integer register out of range: r" + n + " (valid r0..r28)");
            }
        }
        catch (NumberFormatException e) {
            this.err(t, "Malformed integer register: " + t.getText());
        }
    }

    private void checkFloatReg(Token t) {
        String s = t.getText().substring(1);
        try {
            int n = Integer.parseInt(s);
            if (n < 0 || n > 31) {
                this.err(t, "Float register out of range: f" + n + " (valid f0..f31)");
            }
        }
        catch (NumberFormatException e) {
            this.err(t, "Malformed float register: " + t.getText());
        }
    }

    @Override
    public void enterInstrIN(CPUSim64Parser.InstrINContext ctx) {
        for (CPUSim64Parser.ZPortContext zctx : ctx.zPort()) {
            this.checkZPort(zctx.start);
        }
    }

    @Override
    public void enterInstrOUT(CPUSim64Parser.InstrOUTContext ctx) {
        for (CPUSim64Parser.ZPortContext zctx : ctx.zPort()) {
            this.checkZPort(zctx.start);
        }
    }

    private void checkZPort(Token t) {
        Integer val = this.parseIntLike(t);
        if (val == null) {
            this.err(t, "I/O port/size must be an integer literal (dec or hex).");
        } else if (val < 0 || val > 15) {
            this.err(t, "I/O port/size out of range: " + val + " (valid 0..15).");
        }
    }

    @Override
    public void enterInstrJUMP(CPUSim64Parser.InstrJUMPContext ctx) {
        if (ctx.branchModes() != null && ctx.branchModes().zCond() != null) {
            Token t = ctx.branchModes().zCond().start;
            Condition condition = ConditionMapper.fromToken(t, t.getType());
        }
    }

    @Override
    public void enterInstrCALL(CPUSim64Parser.InstrCALLContext ctx) {
        if (ctx.branchModes() != null && ctx.branchModes().zCond() != null) {
            Token t = ctx.branchModes().zCond().start;
            Condition condition = ConditionMapper.fromToken(t, t.getType());
        }
    }

    private Integer parseIntLike(Token t) {
        String s = t.getText();
        try {
            if (s.startsWith("0x") || s.startsWith("0X")) {
                return Integer.parseInt(s.substring(2), 16);
            }
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return null;
        }
    }
}

