/*
 * Decompiled with CFR 0.152.
 */
package cloud.lesh.CPUSim64;

import cloud.lesh.CPUSim64.InterruptHandler;
import cloud.lesh.CPUSim64.LongArray;
import cloud.lesh.CPUSim64.Opcode;
import cloud.lesh.CPUSim64.PortHandler;
import cloud.lesh.CPUSim64.StdIOPortHandler;
import cloud.lesh.CPUSim64.StdInterruptHandler;
import cloud.lesh.CPUSim64.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

public class Simulator {
    public static final int GPR_COUNT = 32;
    public static final int FPR_COUNT = 32;
    public static final int NUM_PORTS = 256;
    public static final int R_SF = 29;
    public static final int R_SP = 30;
    public static final int R_PC = 31;
    public static final int SR_P = 1;
    public static final int SR_Z = 2;
    public static final int SR_S = 4;
    public static final int SR_O = 8;
    long[] mem;
    long[] stack;
    VarHandle atomicMem;
    static LongArray sharedMem;
    long heapStart = 0L;
    long heapLimit = 0L;
    long stackSize = 2048L;
    long stackBase = 0L;
    private long heapList;
    private LinkedList<Long> freeList;
    long[] R = new long[32];
    double[] F = new double[32];
    long SR = 0L;
    private boolean running = false;
    private boolean debug = false;
    private boolean trace = false;
    private long pid;
    private static AtomicLong nextPID;
    private Vector<Simulator> childCPUs = new Vector();
    private static Vector<Simulator> threadCPUs;
    private ChildProcess process = null;
    private ChildThread thread = null;
    private Map<Long, String> reverseSymbolMap = null;
    private InterruptHandler interruptHandler;
    private static final String fmtRegName = "%3s: ";
    private static final String fmtAddress = "%08x";
    private static final int hexSize = 16;
    private static final int decSize = 21;
    private static final int floatSize = 23;
    private static final int fractionSize = 16;
    private static final String padHex;
    private static final String fmtHex = "%016x";
    private static final String padDec;
    private static final String fmtDec = "%21d";
    private static final String fmtFloat = "%23.16g";
    private static final String fmtReg = "%3s: %016x (%d)  ";
    private static final String fmtFP = "%3s: %016x (%.16g)  ";
    private static final String fmtCPU = "%3s: %016x %21d %3s: %23.16g";
    private static final String fmtCPUAlt;
    private static final String fmtStack = " %2sSP+%02d: %016x %21d %23.16g";
    private static final String fmtDisassemble = "%08x: %016x ";
    private static final String fmtPC = "%3s: %016x";
    private static final String fmtHeading = "%3s  %16s %21s %3s  %23s   %5s  %16s %21s %23s\n";
    private static final String[] cpuLabels;
    public static final String[] registers;
    public static final String[] registersFP;
    private Vector<Pair<Long, Long>> protectedMemory = new Vector();
    private static String[] condition;
    long startClock = 0L;
    long totalSystemTime = 0L;
    long cycles = 0L;
    String[] args;
    private static long[] fibonacci;
    private HashMap<Integer, PortHandler> ports = new HashMap();

    public Simulator(int memoryWords, String[] args) {
        this(memoryWords, 0, memoryWords / 10, args);
    }

    public Simulator(int memoryWords, int heapStart, int stackSize, String[] args) {
        this.pid = nextPID.getAndIncrement();
        this.mem = new long[memoryWords];
        this.stack = new long[stackSize];
        this.stackSize = stackSize;
        this.heapStart = heapStart;
        this.heapLimit = memoryWords;
        this.stackBase = memoryWords + stackSize;
        this.atomicMem = MethodHandles.arrayElementVarHandle(long[].class);
        this.interruptHandler = new StdInterruptHandler(this);
        StdIOPortHandler ph = new StdIOPortHandler(this);
        this.setPortHandler(0, ph);
        this.setPortHandler(1, ph);
        this.setPortHandler(2, ph);
        this.args = args;
        this.SR = 2L;
    }

    public Simulator(Simulator cloneMe, boolean makeProcess) throws CPUException {
        this.pid = nextPID.getAndIncrement();
        this.startClock = cloneMe.startClock;
        this.totalSystemTime = cloneMe.totalSystemTime;
        this.cycles = cloneMe.cycles;
        this.args = cloneMe.args;
        this.R = (long[])cloneMe.R.clone();
        this.F = (double[])cloneMe.F.clone();
        this.ports = (HashMap)cloneMe.ports.clone();
        this.interruptHandler = new StdInterruptHandler(this);
        this.setDebug(cloneMe.debug);
        this.setTrace(cloneMe.trace);
        this.reverseSymbolMap = cloneMe.reverseSymbolMap;
        try {
            this.stackBase = cloneMe.stackBase;
            this.stackSize = cloneMe.stackSize;
            this.heapLimit = cloneMe.heapLimit;
            this.heapStart = cloneMe.heapStart;
            if (makeProcess) {
                this.freeList = (LinkedList)cloneMe.freeList.clone();
                this.mem = (long[])cloneMe.mem.clone();
                this.stack = (long[])cloneMe.stack.clone();
                this.atomicMem = MethodHandles.arrayElementVarHandle(long[].class);
            } else {
                this.freeList = cloneMe.freeList;
                this.mem = cloneMe.mem;
                this.stack = new long[(int)this.stackSize];
                this.atomicMem = cloneMe.atomicMem;
            }
            for (Integer i : this.ports.keySet()) {
                if (this.ports.get(i) == null) continue;
                this.ports.put(i, this.ports.get(i).duplicate(this));
            }
        }
        catch (OutOfMemoryError ex) {
            int memoryMax = (int)(this.stackSize + this.heapLimit);
            throw new CPUException("Stack plus Heap size of " + memoryMax + " words is too large for child process!");
        }
    }

    public void loadProgram(List<Long> words, long loadAddr) {
        this.loadProgram(words, loadAddr, new HashMap<Long, String>());
    }

    public void loadProgram(long[] words, long loadAddr, Map<Long, String> reverseSymbolMap) {
        for (int i = 0; i < words.length; ++i) {
            this.mem[Math.toIntExact((long)(loadAddr + (long)i))] = words[i];
        }
        this.R[31] = loadAddr;
        this.R[30] = this.stackBase - 1L;
        this.R[29] = this.R[30];
        if ((long)words.length + loadAddr > this.heapStart) {
            this.heapStart = (long)words.length + loadAddr;
        }
        this.memWrite(this.heapStart, -1L);
        this.memWrite(this.heapStart + 1L, -1L);
        this.memWrite(this.heapStart + 2L, this.heapStart - this.heapLimit);
        this.heapList = this.heapStart;
        this.freeList = new LinkedList();
        this.freeList.push(this.heapList);
        this.reverseSymbolMap = reverseSymbolMap;
    }

    public void loadProgram(List<Long> words, long loadAddr, Map<Long, String> reverseSymbolMap) {
        for (int i = 0; i < words.size(); ++i) {
            this.mem[Math.toIntExact((long)(loadAddr + (long)i))] = words.get(i);
        }
        this.R[31] = loadAddr;
        this.R[30] = this.stackBase - 1L;
        this.R[29] = this.R[30];
        if ((long)words.size() + loadAddr > this.heapStart) {
            this.heapStart = (long)words.size() + loadAddr;
        }
        this.memWrite(this.heapStart, -1L);
        this.memWrite(this.heapStart + 1L, -1L);
        this.memWrite(this.heapStart + 2L, this.heapStart - this.heapLimit);
        this.heapList = this.heapStart;
        this.freeList = new LinkedList();
        this.freeList.push(this.heapList);
        this.reverseSymbolMap = reverseSymbolMap;
    }

    public static long signExtend(long v, int bits) {
        long m = 1L << bits - 1;
        long mask = (1L << bits) - 1L;
        return ((v &= mask) ^ m) - m;
    }

    public int toRegIndex(int kind, int val12) {
        if (Simulator.isRegKind(kind)) {
            this.checkIntReg(val12);
        }
        if (Simulator.isFPKind(kind)) {
            this.checkFPReg(val12);
        }
        return val12 & 0x3F;
    }

    private static boolean isNoneKind(int k) {
        return k == 0;
    }

    private static boolean isConstKind(int k) {
        return k == 1;
    }

    private static boolean isRegKind(int k) {
        return k == 2;
    }

    private static boolean isFPKind(int k) {
        return k == 3;
    }

    private static boolean isXKind(int k) {
        return k == 2 || k == 3;
    }

    private static boolean isYKind(int k) {
        return k == 2 || k == 3;
    }

    private static boolean isOKind(int k) {
        return k == 1 || k == 2;
    }

    private static boolean isQKind(int k) {
        return k != 0;
    }

    private void setFlags(long x, boolean overflowHappened) {
        boolean neg = x < 0L;
        boolean zero = x == 0L;
        boolean oddParity = (Long.bitCount(x) & 1) == 1;
        this.SR = (oddParity ? 1 : 0) | (zero ? 2 : 0) | (neg ? 4 : 0) | (overflowHappened ? 8 : 0);
    }

    private void setFlagsFromSubtract(long a, long b, long result) {
        boolean of = ((a ^ b) & (a ^ result) & Long.MIN_VALUE) != 0L;
        this.setFlags(result, of);
    }

    private void setFlags(double x) {
        boolean neg = x < 0.0;
        boolean zero = x == 0.0;
        boolean oddParity = (Long.bitCount(Double.doubleToRawLongBits(x)) & 1) == 1;
        boolean overflowHappened = Double.isInfinite(x);
        this.SR = (oddParity ? 1 : 0) | (zero ? 2 : 0) | (neg ? 4 : 0) | (overflowHappened ? 8 : 0);
    }

    public String formatSR() {
        boolean P = (this.SR & 1L) != 0L;
        boolean Z = (this.SR & 2L) != 0L;
        boolean S = (this.SR & 4L) != 0L;
        boolean O = (this.SR & 8L) != 0L;
        return (O ? "O" : "o") + (S ? "S" : "s") + (Z ? "Z" : "z") + (P ? "P" : "p");
    }

    private boolean testCond(int z) {
        boolean P = (this.SR & 1L) != 0L;
        boolean Z = (this.SR & 2L) != 0L;
        boolean S = (this.SR & 4L) != 0L;
        boolean O = (this.SR & 8L) != 0L;
        return switch (z) {
            case 0 -> true;
            case 1 -> Z;
            case 2 -> {
                if (!Z) {
                    yield true;
                }
                yield false;
            }
            case 3 -> S;
            case 4 -> {
                if (!S && !Z) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                if (!S) {
                    yield true;
                }
                yield false;
            }
            case 6 -> {
                if (S || Z) {
                    yield true;
                }
                yield false;
            }
            case 7 -> O;
            case 8 -> {
                if (!O) {
                    yield true;
                }
                yield false;
            }
            case 9 -> {
                if (!P) {
                    yield true;
                }
                yield false;
            }
            case 10 -> P;
            default -> false;
        };
    }

    public static synchronized long sharedMemRead(long addr) {
        int a = Math.toIntExact(addr - Long.MIN_VALUE);
        if (a < 0 || a >= sharedMem.size()) {
            throw new RuntimeException(String.format("Illegal shared memory read access of %08x", addr));
        }
        return sharedMem.get(a);
    }

    public long memRead(long addr) {
        long val = 0L;
        if (addr < 0L) {
            val = Simulator.sharedMemRead(addr);
        } else {
            try {
                int a = Math.toIntExact(addr);
                val = (long)a < this.heapLimit ? this.atomicMem.getVolatile(this.mem, a) : this.atomicMem.getVolatile(this.stack, a - (int)this.heapLimit);
                ++this.cycles;
            }
            catch (Exception ex) {
                throw new CPUException(String.format("Illegal memory read access of %08x", addr));
            }
        }
        return val;
    }

    public static synchronized void sharedMemWrite(long addr, long val) {
        int a = Math.toIntExact(addr - Long.MIN_VALUE);
        if (a < 0 || a >= sharedMem.size()) {
            throw new RuntimeException(String.format("Illegal shared memory write access of %08x", addr));
        }
        sharedMem.set(a, val);
    }

    public void memWrite(long addr, long val) {
        if (addr < 0L) {
            try {
                Simulator.sharedMemWrite(addr, val);
            }
            catch (RuntimeException ex) {
                throw new CPUException(String.format("Illegal shared memory write access of %08x", addr));
            }
        }
        if (addr >= this.stackBase) {
            throw new CPUException(String.format("Illegal stack write access of %08x", addr));
        }
        for (Pair<Long, Long> p : this.protectedMemory) {
            if (addr < (Long)p.first || addr >= (Long)p.second) continue;
            throw new CPUException(String.format("Write access violation of %08x", addr));
        }
        try {
            int a = Math.toIntExact(addr);
            if ((long)a < this.heapLimit) {
                this.atomicMem.setVolatile(this.mem, a, val);
            } else {
                this.atomicMem.setVolatile(this.stack, a - (int)this.heapLimit, val);
            }
            ++this.cycles;
        }
        catch (Exception ex) {
            throw new CPUException(String.format("Illegal memory write access of %08x", addr));
        }
    }

    public int getConst(int kind, int val12) {
        if (!Simulator.isConstKind(kind)) {
            throw new CPUException("Illegal constant argument.");
        }
        return val12;
    }

    public long getR(int kind, int val12) {
        if (!Simulator.isRegKind(kind)) {
            throw new CPUException("Illegal A/R argument.");
        }
        int r = this.toRegIndex(kind, val12);
        return this.R[r];
    }

    public void setR(int kind, int val12, long wordBits) {
        if (!Simulator.isRegKind(kind)) {
            throw new CPUException("Illegal A/R argument.");
        }
        int r = this.toRegIndex(kind, val12);
        this.R[r] = wordBits;
        this.setFlags(wordBits, false);
    }

    public double getFP(int kind, int val12) {
        if (!Simulator.isFPKind(kind)) {
            throw new CPUException("Illegal F argument.");
        }
        int r = this.toRegIndex(kind, val12);
        return this.F[r];
    }

    public void setFP(int kind, int val12, double f) {
        if (!Simulator.isFPKind(kind)) {
            throw new CPUException("Illegal F argument.");
        }
        int r = this.toRegIndex(kind, val12);
        this.F[r] = f;
        this.setFlags(f);
    }

    private long getY(int kind, int val12) {
        if (Simulator.isFPKind(kind)) {
            int f = this.toRegIndex(kind, val12);
            return Double.doubleToRawLongBits(this.F[f]);
        }
        if (Simulator.isRegKind(kind)) {
            int r = this.toRegIndex(kind, val12);
            return this.R[r];
        }
        throw new CPUException("Illegal Y argument.");
    }

    private void setY(int kind, int val12, long wordBits) {
        if (Simulator.isFPKind(kind)) {
            int f = this.toRegIndex(kind, val12);
            this.F[f] = Double.longBitsToDouble(wordBits);
            this.setFlags(this.F[f]);
        } else if (Simulator.isRegKind(kind)) {
            int r = this.toRegIndex(kind, val12);
            this.R[r] = wordBits;
            this.setFlags(this.R[r], false);
        } else {
            throw new CPUException("Illegal Y argument.");
        }
    }

    private long getO(int kind, int val12) {
        if (Simulator.isRegKind(kind)) {
            int r = this.toRegIndex(kind, val12);
            return this.R[r];
        }
        if (Simulator.isConstKind(kind)) {
            return val12;
        }
        if (Simulator.isNoneKind(kind)) {
            return 0L;
        }
        throw new CPUException("Illegal O argument.");
    }

    private long getQ(int kind, int val12) {
        if (Simulator.isFPKind(kind)) {
            int f = this.toRegIndex(kind, val12);
            return Double.doubleToRawLongBits(this.F[f]);
        }
        if (Simulator.isRegKind(kind)) {
            int r = this.toRegIndex(kind, val12);
            return this.R[r];
        }
        if (Simulator.isConstKind(kind)) {
            return val12;
        }
        throw new CPUException("Illegal Q argument.");
    }

    private void checkIntReg(int r) {
        if (r < 0 || r >= 32) {
            throw new CPUException("Bad int register: R" + r);
        }
    }

    private void checkFPReg(int f) {
        if (f < 0 || f >= 32) {
            throw new CPUException("Bad FP register: F" + f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(long startPC) {
        this.running = true;
        this.startClock = System.nanoTime();
        this.totalSystemTime = 0L;
        this.cycles = 0L;
        this.R[31] = startPC;
        String fmt = "%5d:%-60.60s%08x ";
        while (this.running) {
            long pc = this.R[31];
            long instr = this.memRead(pc);
            this.R[31] = pc + 1L;
            Decoded d = Decoded.decode(instr);
            if (this.trace) {
                PrintStream printStream = System.out;
                synchronized (printStream) {
                    String label = null;
                    if (this.reverseSymbolMap != null) {
                        label = Decoded.findNearestLabel(this.reverseSymbolMap, pc);
                    }
                    if (label == null) {
                        System.out.print(String.format(fmt, this.getPID(), "", pc));
                    } else {
                        System.out.print(String.format(fmt, this.getPID(), label, pc));
                    }
                    try {
                        System.out.println(d.disassemble(this.reverseSymbolMap));
                    }
                    catch (Exception ex) {
                        System.out.print("DECODE ERROR\n");
                    }
                }
            }
            this.exec(d);
        }
        if (this.debug) {
            PrintStream printStream = System.out;
            synchronized (printStream) {
                this.printCPUState();
            }
        }
        return (int)this.R[0];
    }

    public String disassemble(long startAddress, Map<String, LabelType> symbolTypes) {
        int numStops = 0;
        StringBuffer buffer = new StringBuffer();
        try {
            int i = (int)startAddress;
            while ((long)i < this.heapStart) {
                String label = null;
                if (this.reverseSymbolMap != null) {
                    label = Decoded.findNearestLabel(this.reverseSymbolMap, i);
                }
                if (label == null) {
                    buffer.append(String.format("%08x ", i));
                } else {
                    buffer.append(String.format("%-60.60s %08x ", label, i));
                }
                long instr = this.memRead(i);
                try {
                    LabelType type = symbolTypes.get(label);
                    if (type == null) {
                        Decoded d = Decoded.decode(instr);
                        buffer.append(d.disassemble(this.reverseSymbolMap));
                        if (d.getOpCode() == Opcode.STOP.code) {
                            ++numStops;
                        }
                    } else {
                        switch (symbolTypes.get(label).ordinal()) {
                            case 1: {
                                buffer.append("'" + Utils.escapeString(new String(Character.toChars((int)instr))) + "'");
                                break;
                            }
                            case 2: {
                                buffer.append(Long.toString(instr));
                                break;
                            }
                            case 3: {
                                buffer.append("0x" + Long.toHexString(instr));
                                break;
                            }
                            case 4: {
                                buffer.append(Double.toString(Double.longBitsToDouble(instr)));
                                break;
                            }
                            case 5: {
                                String s = Utils.escapeString(this.convertString(i));
                                i = (int)((long)i + (instr + 7L) / 8L);
                                buffer.append("\"" + s + "\"");
                                break;
                            }
                            default: {
                                buffer.append("0x" + Long.toString(instr, 16));
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    buffer.append("DECODE ERROR");
                }
                buffer.append("\n");
                ++i;
            }
        }
        catch (Exception ex) {
            buffer.append("... Exception during disassembly: " + ex.getMessage() + "\n");
        }
        return buffer.toString();
    }

    private void exec(Decoded d) {
        switch (d.op) {
            case 0: {
                this.opNOP_DEBUG(d);
                break;
            }
            case 1: {
                this.opCLEAR(d);
                break;
            }
            case 2: {
                this.opMOVE(d);
                break;
            }
            case 3: {
                this.opLOAD(d);
                break;
            }
            case 4: {
                this.opSTORE(d);
                break;
            }
            case 5: {
                this.opPOP(d);
                break;
            }
            case 6: {
                this.opPUSH(d);
                break;
            }
            case 7: {
                this.opJUMP(d);
                break;
            }
            case 8: {
                this.opCALL(d);
                break;
            }
            case 9: {
                this.opRETURN(d);
                break;
            }
            case 10: {
                this.opINTERRUPT(d);
                break;
            }
            case 11: {
                this.running = false;
                break;
            }
            case 12: {
                this.opNEGATE(d);
                break;
            }
            case 13: {
                this.opADD(d);
                break;
            }
            case 14: {
                this.opSUB(d);
                break;
            }
            case 15: {
                this.opMULT(d);
                break;
            }
            case 16: {
                this.opDIV_or_RECIP(d);
                break;
            }
            case 17: {
                this.opCOMPL(d);
                break;
            }
            case 18: {
                this.bitwise(d);
                break;
            }
            case 19: {
                this.bitwise(d);
                break;
            }
            case 20: {
                this.bitwise(d);
                break;
            }
            case 21: {
                this.opTEST(d);
                break;
            }
            case 22: {
                this.opCMP(d);
                break;
            }
            case 23: {
                this.bitwise(d);
                break;
            }
            case 24: {
                this.bitwise(d);
                break;
            }
            case 25: {
                this.bitwise(d);
                break;
            }
            case 26: {
                this.bitwise(d);
                break;
            }
            case 27: {
                this.bitwise(d);
                break;
            }
            case 28: {
                this.opIN(d);
                break;
            }
            case 29: {
                this.opOUT(d);
                break;
            }
            case 30: {
                this.opPACK(d);
                break;
            }
            case 31: {
                this.opPACK64(d);
                break;
            }
            case 32: {
                this.opUNPACK(d);
                break;
            }
            case 33: {
                this.opUNPACK64(d);
                break;
            }
            case 34: {
                this.opCAS(d);
                break;
            }
            case 35: {
                this.opENDIAN(d);
                break;
            }
            case 36: {
                this.opSAVE(d);
                break;
            }
            case 37: {
                this.opRESTORE(d);
                break;
            }
            case 38: {
                this.opREADONLY(d);
                break;
            }
            default: {
                throw new IllegalStateException("Unimplemented opcode: " + d.op);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void opNOP_DEBUG(Decoded d) {
        boolean noOps;
        boolean bl = noOps = d.tt == 0 && d.a == 0 && d.b == 0 && d.c == 0 && d.d == 0;
        if (noOps) {
            return;
        }
        if (!this.debug || !this.trace) {
            return;
        }
        PrintStream printStream = System.out;
        synchronized (printStream) {
            if (d.tt == 0) {
                this.printX(d.a, d.v0);
                this.printX(d.b, d.v1);
                this.printX(d.c, d.v2);
                this.printX(d.d, d.v3);
                System.out.println();
            } else {
                this.printCPUState();
            }
        }
    }

    private void printX(int kind, int v) {
        if (kind == 0) {
            return;
        }
        String reg = Decoded.getRegisterOrValue(kind, v);
        if (Simulator.isFPKind(kind)) {
            int f = this.toRegIndex(kind, v);
            if (f < 32) {
                System.out.printf("%s: %.17g  ", reg, this.F[f]);
            }
        } else if (Simulator.isRegKind(kind)) {
            int r = this.toRegIndex(kind, v);
            if (r < 32) {
                System.out.printf("%s: %d  ", reg, this.R[r]);
            }
        } else if (Simulator.isConstKind(kind)) {
            System.out.printf("C(12)=%d  ", v);
        }
    }

    public void clearCPUState() {
        for (int i = 0; i < 29; ++i) {
            this.R[i] = 0L;
        }
        Arrays.fill(this.F, 0.0);
        this.SR = 2L;
    }

    private void opCLEAR(Decoded d) {
        if (d.tt == 0 && d.a == 0) {
            this.clearCPUState();
            return;
        }
        if (Simulator.isRegKind(d.a)) {
            this.setR(d.a, d.v0, 0L);
        }
        if (Simulator.isFPKind(d.a)) {
            this.setFP(d.a, d.v0, 0.0);
        }
        if (Simulator.isRegKind(d.b)) {
            this.setR(d.b, d.v1, 0L);
        }
        if (Simulator.isFPKind(d.b)) {
            this.setFP(d.b, d.v1, 0.0);
        }
        if (Simulator.isRegKind(d.c)) {
            this.setR(d.c, d.v2, 0L);
        }
        if (Simulator.isFPKind(d.c)) {
            this.setFP(d.c, d.v2, 0.0);
        }
        if (Simulator.isRegKind(d.d)) {
            this.setR(d.d, d.v3, 0L);
        }
        if (Simulator.isFPKind(d.d)) {
            this.setFP(d.d, d.v3, 0.0);
        }
        this.SR = 2L;
    }

    private void opMOVE(Decoded d) {
        if (d.tt == 0) {
            if (d.getArgCount() == 2) {
                if (Simulator.isRegKind(d.b)) {
                    long k = this.getR(d.b, d.v1);
                    if (Simulator.isRegKind(d.a)) {
                        this.setR(d.a, d.v0, k);
                        return;
                    }
                    if (Simulator.isFPKind(d.a)) {
                        this.setFP(d.a, d.v0, k);
                        return;
                    }
                } else if (Simulator.isFPKind(d.b)) {
                    double fp = this.getFP(d.b, d.v1);
                    if (Simulator.isRegKind(d.a)) {
                        this.setR(d.a, d.v0, (long)fp);
                        return;
                    }
                    if (Simulator.isFPKind(d.a)) {
                        this.setFP(d.a, d.v0, fp);
                        return;
                    }
                }
            } else if (d.getArgCount() == 3) {
                if (Simulator.isRegKind(d.a) && Simulator.isRegKind(d.b) && Simulator.isRegKind(d.c)) {
                    this.setR(d.a, d.v0, this.getR(d.b, d.v1) + this.getR(d.c, d.v2));
                    return;
                }
            } else if (d.getArgCount() == 4 && Simulator.isConstKind(d.a) && Simulator.isYKind(d.b) && Simulator.isQKind(d.c) && Simulator.isQKind(d.d)) {
                long k;
                double fp;
                if (this.testCond(d.v0)) {
                    if (Simulator.isFPKind(d.c)) {
                        fp = this.getFP(d.c, d.v2);
                        k = (long)fp;
                    } else {
                        k = this.getO(d.c, d.v2);
                        fp = k;
                    }
                } else if (Simulator.isFPKind(d.d)) {
                    fp = this.getFP(d.d, d.v3);
                    k = (long)fp;
                } else {
                    k = this.getO(d.d, d.v3);
                    fp = k;
                }
                if (Simulator.isRegKind(d.b)) {
                    this.setR(d.b, d.v1, k);
                    return;
                }
                if (Simulator.isFPKind(d.b)) {
                    this.setFP(d.b, d.v1, fp);
                    return;
                }
            }
        } else if (d.tt == 2) {
            long k = d.c2;
            if (Simulator.isRegKind(d.a)) {
                this.setR(d.a, d.v0, k);
                return;
            }
            if (Simulator.isFPKind(d.a)) {
                this.setFP(d.a, d.v0, k);
                return;
            }
        } else if (d.tt == 3 && Simulator.isRegKind(d.a) && Simulator.isRegKind(d.b)) {
            this.setR(d.a, d.v0, this.getR(d.b, d.v1) + (long)d.c3);
            return;
        }
        throw new CPUException("Illegal MOVE arguments.");
    }

    private void opLOAD(Decoded d) {
        if (d.tt == 2) {
            long addr = d.c2;
            long word = this.memRead(addr);
            this.setY(d.a, d.v0, word);
            return;
        }
        if (d.tt == 0) {
            int count = d.getArgCount();
            if (count == 2 && Simulator.isYKind(d.a) && Simulator.isRegKind(d.b)) {
                long addr = this.getR(d.b, d.v1);
                long w = this.memRead(addr);
                this.setY(d.a, d.v0, w);
                return;
            }
            if (count == 3 && Simulator.isYKind(d.a) && Simulator.isRegKind(d.b) && Simulator.isRegKind(d.c)) {
                long base = this.getR(d.b, d.v1);
                long off = this.getR(d.c, d.v2);
                this.setY(d.a, d.v0, this.memRead(base + off));
                return;
            }
        } else if (d.tt == 3 && Simulator.isYKind(d.a) && Simulator.isOKind(d.b)) {
            long base = this.getO(d.b, d.v1);
            long addr = base + (long)d.c3;
            this.setY(d.a, d.v0, this.memRead(addr));
            return;
        }
        throw new IllegalStateException("Illegal LOAD arguments.");
    }

    private void opSTORE(Decoded d) {
        if (d.tt == 2) {
            long val = this.getQ(d.a, d.v0);
            long addr = d.c2;
            this.memWrite(addr, val);
            return;
        }
        if (d.tt == 0) {
            int count = d.getArgCount();
            if (count == 2 && Simulator.isQKind(d.a) && Simulator.isRegKind(d.b)) {
                long addr = this.getR(d.b, d.v1);
                long val = this.getQ(d.a, d.v0);
                this.memWrite(addr, val);
                return;
            }
            if (count == 3 && Simulator.isQKind(d.a) && Simulator.isRegKind(d.b) && Simulator.isRegKind(d.c)) {
                long base = this.getR(d.b, d.v1);
                long addr = base + this.getR(d.c, d.v2);
                long val = this.getQ(d.a, d.v0);
                this.memWrite(addr, val);
                return;
            }
        } else if (d.tt == 3) {
            if (Simulator.isQKind(d.a) && Simulator.isRegKind(d.b)) {
                long base = this.getR(d.b, d.v1);
                long addr = base + (long)d.c3;
                long val = this.getQ(d.a, d.v0);
                this.memWrite(addr, val);
                return;
            }
            if (Simulator.isQKind(d.a) && Simulator.isConstKind(d.b)) {
                long base = this.getO(d.b, d.v1);
                long addr = base + (long)d.c3;
                long val = this.getQ(d.a, d.v0);
                this.memWrite(addr, val);
                return;
            }
        }
        throw new IllegalStateException("Illegal STORE arguments.");
    }

    private void opPOP(Decoded d) {
        this.R[30] = this.R[30] + 1L;
        long val = this.memRead(this.R[30]);
        if (d.tt == 0) {
            if (d.a == 0) {
                return;
            }
            if (Simulator.isYKind(d.a)) {
                this.setY(d.a, d.v0, val);
                return;
            }
        }
        throw new IllegalStateException("POP form not implemented");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void opPUSH(Decoded d) {
        long val;
        if (d.tt == 1) {
            val = d.c1;
        } else {
            if (d.tt != 0) throw new CPUException("Illegal PUSH instruction");
            if (!Simulator.isYKind(d.a)) throw new CPUException("Illegal PUSH instruction");
            val = this.getY(d.a, d.v0);
        }
        this.memWrite(this.R[30], val);
        this.R[30] = this.R[30] - 1L;
        if (this.R[30] >= this.heapLimit) return;
        throw new CPUException("Stack/Heap collision");
    }

    private void opJUMP(Decoded d) {
        if (d.tt != 1 && Simulator.isConstKind(d.a) && !this.testCond(this.getConst(d.a, d.v0))) {
            return;
        }
        if (d.tt == 1) {
            this.R[31] = d.c1;
            return;
        }
        if (Simulator.isConstKind(d.a)) {
            long addr;
            this.R[31] = addr = this.getO(d.b, d.v1) + this.getO(d.c, d.v2) + d.c1 + d.c2 + (long)d.c3;
        } else if (Simulator.isRegKind(d.a)) {
            long addr;
            this.R[31] = addr = this.getO(d.a, d.v0) + this.getO(d.b, d.v1) + d.c1 + d.c2 + (long)d.c3;
        } else {
            throw new IllegalStateException("Illegal JUMP arguments.");
        }
    }

    private void opCALL(Decoded d) {
        if (d.tt != 1 && Simulator.isConstKind(d.a) && !this.testCond(this.getConst(d.a, d.v0))) {
            return;
        }
        this.memWrite(this.R[30], this.R[31]);
        this.R[30] = this.R[30] - 1L;
        this.memWrite(this.R[30], this.R[29]);
        this.R[30] = this.R[30] - 1L;
        this.R[29] = this.R[30];
        this.opJUMP(d);
    }

    private void opRETURN(Decoded d) {
        this.R[30] = this.R[29];
        this.R[30] = this.R[30] + 1L;
        this.R[29] = this.memRead(this.R[30]);
        this.R[30] = this.R[30] + 1L;
        this.R[31] = this.memRead(this.R[30]);
        if (this.R[31] < 0L) {
            this.exit((int)this.R[31]);
        }
    }

    private void opINTERRUPT(Decoded d) {
        long code = -1L;
        if (d.tt == 1) {
            code = d.c1;
        } else if (d.tt == 2) {
            code = this.testCond(this.getConst(d.a, d.v0)) ? d.c2 : 0L;
        } else if (d.tt == 0) {
            int count = d.getArgCount();
            if (count == 1 && Simulator.isOKind(d.a)) {
                code = this.getO(d.a, d.v0);
            } else if (count == 2 && Simulator.isOKind(d.b)) {
                code = this.testCond(this.getConst(d.a, d.v0)) ? this.getO(d.b, d.v1) : 0L;
            }
        }
        if (code > 0L) {
            long start = System.nanoTime();
            this.interruptHandler.dispatch((int)code);
            long stop = System.nanoTime();
            this.totalSystemTime += stop - start;
        } else if (code < 0L) {
            throw new IllegalStateException("Illegal INTERRUPT arguments.");
        }
    }

    private void opNEGATE(Decoded d) {
        if (d.tt == 0 && Simulator.isFPKind(d.a)) {
            int f = this.toRegIndex(d.a, d.v0);
            this.F[f] = -this.F[f];
        } else if (d.tt == 0 && Simulator.isRegKind(d.a)) {
            int r = this.toRegIndex(d.a, d.v0);
            long res = -this.R[r];
            this.setFlags(res, this.R[r] == Long.MIN_VALUE);
            this.R[r] = res;
        } else {
            throw new IllegalStateException("NEGATE form not implemented");
        }
    }

    private void opADD(Decoded d) {
        if (d.tt == 0) {
            int count = d.getArgCount();
            if (count == 2) {
                if (Simulator.isRegKind(d.a) && Simulator.isRegKind(d.b)) {
                    long rhs;
                    long res;
                    int rd = this.toRegIndex(d.a, d.v0);
                    long before = this.R[rd];
                    boolean of = ((before ^ (res = before + (rhs = this.R[this.toRegIndex(d.b, d.v1)]))) & (rhs ^ res)) < 0L;
                    this.R[rd] = res;
                    this.setFlags(res, of);
                    return;
                }
                if (Simulator.isFPKind(d.a)) {
                    double res;
                    int rd = this.toRegIndex(d.a, d.v0);
                    double before = this.F[rd];
                    double rhs = Simulator.isFPKind(d.b) ? this.F[this.toRegIndex(d.b, d.v1)] : (double)this.R[this.toRegIndex(d.b, d.v1)];
                    this.F[rd] = res = before + rhs;
                    this.setFlags(res);
                    return;
                }
            } else if (count == 3) {
                if (Simulator.isRegKind(d.a) && Simulator.isRegKind(d.b) && Simulator.isRegKind(d.c)) {
                    long rhs;
                    long res;
                    int rd = this.toRegIndex(d.b, d.v1);
                    long before = this.R[rd];
                    boolean of = ((before ^ (res = before + (rhs = this.R[this.toRegIndex(d.c, d.v2)]))) & (rhs ^ res)) < 0L;
                    this.R[this.toRegIndex((int)d.a, (int)d.v0)] = res;
                    this.setFlags(res, of);
                    return;
                }
                if (Simulator.isFPKind(d.a) && Simulator.isFPKind(d.b)) {
                    double res;
                    int rd = this.toRegIndex(d.b, d.v1);
                    double before = this.F[rd];
                    double rhs = Simulator.isFPKind(d.c) ? this.F[this.toRegIndex(d.c, d.v2)] : (double)this.R[this.toRegIndex(d.c, d.v2)];
                    this.F[this.toRegIndex((int)d.a, (int)d.v0)] = res = before + rhs;
                    this.setFlags(res);
                    return;
                }
            }
        } else if (d.tt == 2 && Simulator.isYKind(d.a)) {
            if (Simulator.isRegKind(d.a)) {
                long rhs;
                long res;
                int rd = this.toRegIndex(d.a, d.v0);
                long before = this.R[rd];
                boolean of = ((before ^ (res = before + (rhs = d.c2))) & (rhs ^ res)) < 0L;
                this.R[rd] = res;
                this.setFlags(res, of);
                return;
            }
            if (Simulator.isFPKind(d.a)) {
                double res;
                int rd = this.toRegIndex(d.a, d.v0);
                double before = this.F[rd];
                double rhs = d.c2;
                this.F[rd] = res = before + rhs;
                this.setFlags(res);
                return;
            }
        } else if (d.tt == 3) {
            if (Simulator.isRegKind(d.a) && Simulator.isRegKind(d.b)) {
                long rhs;
                long res;
                int rd = this.toRegIndex(d.b, d.v1);
                long before = this.R[rd];
                boolean of = ((before ^ (res = before + (rhs = (long)d.c3))) & (rhs ^ res)) < 0L;
                this.R[this.toRegIndex((int)d.a, (int)d.v0)] = res;
                this.setFlags(res, of);
                return;
            }
            if (Simulator.isFPKind(d.a) && Simulator.isFPKind(d.b)) {
                double res;
                int rd = this.toRegIndex(d.b, d.v1);
                double before = this.F[rd];
                double rhs = d.c3;
                this.F[this.toRegIndex((int)d.a, (int)d.v0)] = res = before + rhs;
                this.setFlags(res);
                return;
            }
        }
        throw new IllegalStateException("ADD form not implemented");
    }

    private void opSUB(Decoded d) {
        if (d.tt == 0) {
            int count = d.getArgCount();
            if (count == 2) {
                if (Simulator.isRegKind(d.a) && Simulator.isRegKind(d.b)) {
                    long res;
                    long rhs;
                    int rd = this.toRegIndex(d.a, d.v0);
                    long before = this.R[rd];
                    boolean of = ((before ^ (rhs = this.R[this.toRegIndex(d.b, d.v1)])) & (before ^ (res = before - rhs))) < 0L;
                    this.R[rd] = res;
                    this.setFlags(res, of);
                    return;
                }
                if (Simulator.isFPKind(d.a)) {
                    double res;
                    int rd = this.toRegIndex(d.a, d.v0);
                    double before = this.F[rd];
                    double rhs = Simulator.isFPKind(d.b) ? this.F[this.toRegIndex(d.b, d.v1)] : (double)this.R[this.toRegIndex(d.b, d.v1)];
                    this.F[rd] = res = before - rhs;
                    this.setFlags(res);
                    return;
                }
            } else if (count == 3) {
                if (Simulator.isRegKind(d.a) && Simulator.isRegKind(d.b) && Simulator.isRegKind(d.c)) {
                    long res;
                    long rhs;
                    int rd = this.toRegIndex(d.b, d.v1);
                    long before = this.R[rd];
                    boolean of = ((before ^ (rhs = this.R[this.toRegIndex(d.c, d.v2)])) & (before ^ (res = before - rhs))) < 0L;
                    this.R[this.toRegIndex((int)d.a, (int)d.v0)] = res;
                    this.setFlags(res, of);
                    return;
                }
                if (Simulator.isFPKind(d.a) && Simulator.isFPKind(d.b)) {
                    double res;
                    int rd = this.toRegIndex(d.b, d.v1);
                    double before = this.F[rd];
                    double rhs = Simulator.isFPKind(d.c) ? this.F[this.toRegIndex(d.c, d.v2)] : (double)this.R[this.toRegIndex(d.c, d.v2)];
                    this.F[this.toRegIndex((int)d.a, (int)d.v0)] = res = before - rhs;
                    this.setFlags(res);
                    return;
                }
            }
        } else if (d.tt == 2 && Simulator.isYKind(d.a)) {
            if (Simulator.isRegKind(d.a)) {
                long res;
                long rhs;
                int rd = this.toRegIndex(d.a, d.v0);
                long before = this.R[rd];
                boolean of = ((before ^ (rhs = d.c2)) & (before ^ (res = before - rhs))) < 0L;
                this.R[rd] = res;
                this.setFlags(res, of);
                return;
            }
            if (Simulator.isFPKind(d.a)) {
                double res;
                int rd = this.toRegIndex(d.a, d.v0);
                double before = this.F[rd];
                double rhs = d.c2;
                this.F[rd] = res = before - rhs;
                this.setFlags(res);
                return;
            }
        } else if (d.tt == 3) {
            if (Simulator.isRegKind(d.a) && Simulator.isRegKind(d.b)) {
                long res;
                long rhs;
                int rd = this.toRegIndex(d.b, d.v1);
                long before = this.R[rd];
                boolean of = ((before ^ (rhs = (long)d.c3)) & (before ^ (res = before - rhs))) < 0L;
                this.R[this.toRegIndex((int)d.a, (int)d.v0)] = res;
                this.setFlags(res, of);
                return;
            }
            if (Simulator.isFPKind(d.a) && Simulator.isFPKind(d.b)) {
                double res;
                int rd = this.toRegIndex(d.b, d.v1);
                double before = this.F[rd];
                double rhs = d.c3;
                this.F[this.toRegIndex((int)d.a, (int)d.v0)] = res = before - rhs;
                this.setFlags(res);
                return;
            }
        }
        throw new IllegalStateException("SUB form not implemented");
    }

    private void opMULT(Decoded d) {
        if (d.tt == 0) {
            int count = d.getArgCount();
            if (count == 2) {
                if (Simulator.isRegKind(d.a) && Simulator.isRegKind(d.b)) {
                    long rhs;
                    int rd = this.toRegIndex(d.a, d.v0);
                    long before = this.R[rd];
                    long res = before * (rhs = this.R[this.toRegIndex(d.b, d.v1)]);
                    boolean of = res != 0L && res / rhs != before;
                    this.R[rd] = res;
                    this.setFlags(res, of);
                    return;
                }
                if (Simulator.isFPKind(d.a)) {
                    double res;
                    int rd = this.toRegIndex(d.a, d.v0);
                    double before = this.F[rd];
                    double rhs = Simulator.isFPKind(d.b) ? this.F[this.toRegIndex(d.b, d.v1)] : (double)this.R[this.toRegIndex(d.b, d.v1)];
                    this.F[rd] = res = before * rhs;
                    this.setFlags(res);
                    return;
                }
            } else if (count == 3) {
                if (Simulator.isRegKind(d.a) && Simulator.isRegKind(d.b) && Simulator.isRegKind(d.c)) {
                    long rhs;
                    int rd = this.toRegIndex(d.b, d.v1);
                    long before = this.R[rd];
                    long res = before * (rhs = this.R[this.toRegIndex(d.c, d.v2)]);
                    boolean of = res != 0L && res / rhs != before;
                    this.R[this.toRegIndex((int)d.a, (int)d.v0)] = res;
                    this.setFlags(res, of);
                    return;
                }
                if (Simulator.isFPKind(d.a) && Simulator.isFPKind(d.b)) {
                    double res;
                    int rd = this.toRegIndex(d.b, d.v1);
                    double before = this.F[rd];
                    double rhs = Simulator.isFPKind(d.c) ? this.F[this.toRegIndex(d.c, d.v2)] : (double)this.R[this.toRegIndex(d.c, d.v2)];
                    this.F[this.toRegIndex((int)d.a, (int)d.v0)] = res = before * rhs;
                    this.setFlags(res);
                    return;
                }
            }
        } else if (d.tt == 2 && Simulator.isYKind(d.a)) {
            if (Simulator.isRegKind(d.a)) {
                long rhs;
                int rd = this.toRegIndex(d.a, d.v0);
                long before = this.R[rd];
                long res = before * (rhs = d.c2);
                boolean of = res == 0L && res / rhs != before;
                this.R[rd] = res;
                this.setFlags(res, of);
                return;
            }
            if (Simulator.isFPKind(d.a)) {
                double res;
                int rd = this.toRegIndex(d.a, d.v0);
                double before = this.F[rd];
                double rhs = d.c2;
                this.F[rd] = res = before * rhs;
                this.setFlags(res);
                return;
            }
        } else if (d.tt == 3) {
            if (Simulator.isRegKind(d.a) && Simulator.isRegKind(d.b)) {
                long rhs;
                int rd = this.toRegIndex(d.b, d.v1);
                long before = this.R[rd];
                long res = before * (rhs = (long)d.c3);
                boolean of = res == 0L && res / rhs != before;
                this.R[this.toRegIndex((int)d.a, (int)d.v0)] = res;
                this.setFlags(res, of);
                return;
            }
            if (Simulator.isFPKind(d.a) && Simulator.isFPKind(d.b)) {
                double res;
                int rd = this.toRegIndex(d.b, d.v1);
                double before = this.F[rd];
                double rhs = d.c3;
                this.F[this.toRegIndex((int)d.a, (int)d.v0)] = res = before * rhs;
                this.setFlags(res);
                return;
            }
        }
        throw new IllegalStateException("MULT form not implemented");
    }

    private void opDIV_or_RECIP(Decoded d) {
        if (d.tt == 0) {
            int count = d.getArgCount();
            if (count == 1) {
                double res;
                this.F[this.toRegIndex((int)d.a, (int)d.v0)] = res = 1.0 / this.getFP(d.a, d.v0);
                this.setFlags(res);
                return;
            }
            if (count == 2) {
                if (Simulator.isRegKind(d.a) && Simulator.isRegKind(d.b)) {
                    int rd = this.toRegIndex(d.a, d.v0);
                    long before = this.R[rd];
                    long rhs = this.R[this.toRegIndex(d.b, d.v1)];
                    long res = before / rhs;
                    boolean of = before == Long.MIN_VALUE && rhs == -1L;
                    this.R[rd] = res;
                    this.setFlags(res, of);
                    return;
                }
                if (Simulator.isFPKind(d.a)) {
                    double res;
                    int rd = this.toRegIndex(d.a, d.v0);
                    double before = this.F[rd];
                    double rhs = Simulator.isFPKind(d.b) ? this.F[this.toRegIndex(d.b, d.v1)] : (double)this.R[this.toRegIndex(d.b, d.v1)];
                    this.F[rd] = res = before / rhs;
                    this.setFlags(res);
                    return;
                }
            } else if (count == 3) {
                if (Simulator.isRegKind(d.a) && Simulator.isRegKind(d.b) && Simulator.isRegKind(d.c)) {
                    int rd = this.toRegIndex(d.b, d.v1);
                    long before = this.R[rd];
                    long rhs = this.R[this.toRegIndex(d.c, d.v2)];
                    long res = before / rhs;
                    boolean of = before == Long.MIN_VALUE && rhs == -1L;
                    this.R[this.toRegIndex((int)d.a, (int)d.v0)] = res;
                    this.setFlags(res, of);
                    return;
                }
                if (Simulator.isFPKind(d.a) && Simulator.isFPKind(d.b)) {
                    double res;
                    int rd = this.toRegIndex(d.b, d.v1);
                    double before = this.F[rd];
                    double rhs = Simulator.isFPKind(d.c) ? this.F[this.toRegIndex(d.c, d.v2)] : (double)this.R[this.toRegIndex(d.c, d.v2)];
                    this.F[this.toRegIndex((int)d.a, (int)d.v0)] = res = before / rhs;
                    this.setFlags(res);
                    return;
                }
            } else if (count == 4) {
                long a = this.getR(d.c, d.v2);
                long b = this.getO(d.d, d.v3);
                this.setR(d.a, d.v0, a / b);
                this.setR(d.b, d.v1, a % b);
                boolean of = a == Long.MIN_VALUE && b == -1L;
                this.setFlags(this.getR(d.a), of);
                return;
            }
        } else if (d.tt == 2 && Simulator.isYKind(d.a)) {
            if (Simulator.isRegKind(d.a)) {
                int rd = this.toRegIndex(d.a, d.v0);
                long before = this.R[rd];
                long rhs = d.c2;
                long res = before / rhs;
                boolean of = before == Long.MIN_VALUE && rhs == -1L;
                this.R[rd] = res;
                this.setFlags(res, of);
                return;
            }
            if (Simulator.isFPKind(d.a)) {
                double res;
                int rd = this.toRegIndex(d.a, d.v0);
                double before = this.F[rd];
                double rhs = d.c2;
                this.F[rd] = res = before / rhs;
                this.setFlags(res);
                return;
            }
        } else if (d.tt == 3) {
            if (Simulator.isRegKind(d.a) && Simulator.isRegKind(d.b)) {
                int rd = this.toRegIndex(d.b, d.v1);
                long before = this.R[rd];
                long rhs = d.c3;
                long res = before / rhs;
                boolean of = before == Long.MIN_VALUE && rhs == -1L;
                this.R[this.toRegIndex((int)d.a, (int)d.v0)] = res;
                this.setFlags(res, of);
                return;
            }
            if (Simulator.isFPKind(d.a) && Simulator.isFPKind(d.b)) {
                double res;
                int rd = this.toRegIndex(d.b, d.v1);
                double before = this.F[rd];
                double rhs = d.c3;
                this.F[this.toRegIndex((int)d.a, (int)d.v0)] = res = before / rhs;
                this.setFlags(res);
                return;
            }
        }
        throw new IllegalStateException("DIV/RECIP form not implemented");
    }

    private void opCOMPL(Decoded d) {
        if (d.tt == 0 && Simulator.isRegKind(d.a)) {
            this.setR(d.a, d.v0, this.getR(d.a, d.v0) ^ 0xFFFFFFFFFFFFFFFFL);
            return;
        }
        throw new IllegalStateException("COMPL form not implemented");
    }

    private void bitwise(Decoded d) {
        long l;
        assert (Opcode.AND.code == 18);
        assert (Opcode.OR.code == 19);
        assert (Opcode.XOR.code == 20);
        assert (Opcode.LSHIFT.code == 23);
        assert (Opcode.RSHIFT.code == 24);
        assert (Opcode.ARSHIFT.code == 25);
        assert (Opcode.LROTATE.code == 26);
        assert (Opcode.RROTATE.code == 27);
        boolean isGood = false;
        long lhs = 0L;
        long rhs = 0L;
        if (d.tt == 0) {
            int count = d.getArgCount();
            if (count == 2 || count == 3) {
                if (count == 2) {
                    lhs = this.getR(d.a, d.v0);
                    rhs = this.getR(d.b, d.v1);
                } else {
                    lhs = this.getO(d.b, d.v1);
                    rhs = this.getO(d.c, d.v2);
                }
                isGood = true;
            }
        } else if (d.tt == 2) {
            lhs = this.getR(d.a, d.v0);
            rhs = d.c2;
            isGood = true;
        } else if (d.tt == 3) {
            lhs = this.getR(d.b, d.v1);
            rhs = d.c3;
            isGood = true;
        }
        if (isGood) {
            if (rhs < 0L && d.op >= 23) {
                throw new CPUException("Illegal negative shift on bitwise operator");
            }
            switch (d.op) {
                case 18: {
                    l = lhs & rhs;
                    break;
                }
                case 19: {
                    l = lhs | rhs;
                    break;
                }
                case 20: {
                    l = lhs ^ rhs;
                    break;
                }
                case 23: {
                    l = lhs << (int)rhs;
                    break;
                }
                case 24: {
                    l = lhs >>> (int)rhs;
                    break;
                }
                case 25: {
                    l = lhs >> (int)rhs;
                    break;
                }
                case 26: {
                    l = Long.rotateLeft(lhs, (int)rhs);
                    break;
                }
                case 27: {
                    l = Long.rotateRight(lhs, (int)rhs);
                    break;
                }
                default: {
                    throw new CPUException("Illegal bitwise operator");
                }
            }
        } else {
            throw new CPUException("Illegal bitwise arguments");
        }
        long res = l;
        this.setR(d.a, d.v0, res);
    }

    private void opTEST(Decoded d) {
        if (d.tt != 1) {
            if (Simulator.isFPKind(d.a)) {
                double f = this.getFP(d.a, d.v0);
                this.setFlags(f);
                return;
            }
            long bits = this.getO(d.a, d.v0);
            this.setFlags(bits, false);
            return;
        }
        throw new IllegalStateException("TEST form not implemented");
    }

    private void opCMP(Decoded d) {
        if (d.tt == 0 && !Simulator.isFPKind(d.a) && !Simulator.isFPKind(d.b)) {
            long a1 = this.getQ(d.a, d.v0);
            long a2 = this.getQ(d.b, d.v1);
            long res = a1 - a2;
            this.setFlagsFromSubtract(a1, a2, res);
            return;
        }
        if (d.tt == 2 && !Simulator.isFPKind(d.a)) {
            long a = this.getY(d.a, d.v0);
            long c = d.c2;
            long res = a - c;
            this.setFlagsFromSubtract(a, c, res);
            return;
        }
        if (d.tt == 0 && Simulator.isFPKind(d.a) && Simulator.isFPKind(d.b)) {
            double f1 = this.F[this.toRegIndex(d.a, d.v0)];
            double f2 = this.F[this.toRegIndex(d.b, d.v1)];
            long res = (long)Math.signum(f1 - f2);
            this.setFlags(res, false);
            return;
        }
        throw new IllegalStateException("CMP form not implemented");
    }

    private void opOUT(Decoded d) {
        int count;
        if (d.tt == 0 && (count = d.getArgCount()) == 3) {
            int bytes = (int)this.getO(d.b, d.v1);
            int port = (int)this.getO(d.c, d.v2);
            long val = this.getQ(d.a, d.v0);
            if (Simulator.isFPKind(d.a) && bytes != 8) {
                throw new CPUException("OUT for FP must be 8 bytes");
            }
            if (bytes < 0 || bytes > 8) {
                throw new CPUException("OUT number of bytes must be 0-8");
            }
            PortHandler ph = this.getPortHandler(port);
            ph.setPort(port);
            if (ph == null) {
                throw new CPUException("OUT port " + port + " handler not set");
            }
            if (bytes == 0) {
                ph.writeChar((int)val);
            } else {
                ph.write(val, bytes);
            }
            return;
        }
        throw new CPUException("OUT form not implemented");
    }

    private void opIN(Decoded d) {
        int count;
        if (d.tt == 0 && (count = d.getArgCount()) == 3) {
            int bytes = (int)this.getO(d.b, d.v1);
            int port = (int)this.getO(d.c, d.v2);
            if (Simulator.isFPKind(d.a) && bytes != 8) {
                throw new CPUException("IN for FP must be 8 bytes");
            }
            if (bytes < 0 || bytes > 8) {
                throw new CPUException("IN number of bytes must be 0-8");
            }
            PortHandler ph = this.getPortHandler(port);
            ph.setPort(port);
            if (ph == null) {
                throw new CPUException("IN port " + port + " handler not set");
            }
            long val = 0L;
            val = bytes == 0 ? (long)ph.readChar() : ph.read(bytes);
            this.setY(d.a, d.v0, val);
            return;
        }
        throw new CPUException("OUT form not implemented");
    }

    private void opPACK(Decoded d) {
        if (d.tt == 0) {
            int count = d.getArgCount();
            if (count == 2) {
                this.setR(d.a, d.v0, (this.getR(d.a, d.v0) & 0xFFFFL) << 16 | this.getR(d.b, d.v1) & 0xFFFFL);
                return;
            }
            if (count == 4) {
                this.setR(d.a, d.v0, (this.getR(d.a, d.v0) & 0xFFL) << 24 | (this.getR(d.b, d.v1) & 0xFFL) << 16 | (this.getR(d.c, d.v2) & 0xFFL) << 8 | this.getR(d.d, d.v3) & 0xFFL);
                return;
            }
        }
        throw new CPUException("PACK form not implemented");
    }

    private void opPACK64(Decoded d) {
        if (d.tt == 0) {
            int count = d.getArgCount();
            if (count == 2) {
                this.setR(d.a, d.v0, (this.getR(d.a, d.v0) & 0xFFFFFFFFL) << 32 | this.getR(d.b, d.v1) & 0xFFFFFFFFL);
                return;
            }
            if (count == 4) {
                this.setR(d.a, d.v0, (this.getR(d.a, d.v0) & 0xFFFFL) << 48 | (this.getR(d.b, d.v1) & 0xFFFFL) << 32 | (this.getR(d.c, d.v2) & 0xFFFFL) << 16 | this.getR(d.d, d.v3) & 0xFFFFL);
                return;
            }
        }
        throw new CPUException("PACK64 form not implemented");
    }

    private void opUNPACK(Decoded d) {
        if (d.tt == 0) {
            int count = d.getArgCount();
            if (count == 2) {
                long v = this.getR(d.a, d.v0);
                this.setR(d.a, d.v0, v >> 16 & 0xFFFFL);
                this.setR(d.b, d.v1, v & 0xFFFFL);
                return;
            }
            if (count == 4) {
                long v = this.getR(d.a, d.v0);
                this.setR(d.d, d.v3, v & 0xFFL);
                this.setR(d.c, d.v2, (v >>= 8) & 0xFFL);
                this.setR(d.b, d.v1, (v >>= 8) & 0xFFL);
                this.setR(d.a, d.v0, (v >>= 8) & 0xFFL);
                return;
            }
        }
        throw new CPUException("UNPACK form not implemented");
    }

    private void opUNPACK64(Decoded d) {
        if (d.tt == 0) {
            int count = d.getArgCount();
            if (count == 2) {
                long v = this.getR(d.a, d.v0);
                this.setR(d.a, d.v0, v >> 32 & 0xFFFFFFFFL);
                this.setR(d.b, d.v1, v & 0xFFFFFFFFL);
                return;
            }
            if (count == 4) {
                long v = this.getR(d.a, d.v0);
                this.setR(d.d, d.v3, v & 0xFFFFL);
                this.setR(d.c, d.v2, (v >>= 16) & 0xFFFFL);
                this.setR(d.b, d.v1, (v >>= 16) & 0xFFFFL);
                this.setR(d.a, d.v0, (v >>= 16) & 0xFFFFL);
                return;
            }
        }
        throw new CPUException("UNPACK64 form not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void opCAS(Decoded d) {
        int count;
        if (d.tt == 0 && ((count = d.getArgCount()) == 3 || count == 4)) {
            long oldVal = this.getO(d.a, d.v0);
            long newVal = this.getO(d.b, d.v1);
            long base = this.getR(d.c, d.v2);
            long offset = count == 4 ? this.getO(d.d, d.v3) : 0L;
            long addr = base + offset;
            try {
                boolean ok;
                if (addr < 0L) {
                    Class<Simulator> clazz = Simulator.class;
                    synchronized (Simulator.class) {
                        long curVal = this.memRead(addr);
                        if (curVal == oldVal) {
                            this.memWrite(addr, newVal);
                            ok = true;
                        } else {
                            ok = false;
                        }
                        // ** MonitorExit[var14_8] (shouldn't be in output)
                    }
                } else {
                    ok = addr < this.heapLimit ? this.atomicMem.compareAndSet(this.mem, Math.toIntExact(addr), oldVal, newVal) : this.atomicMem.compareAndSet(this.stack, Math.toIntExact(addr - this.heapLimit), oldVal, newVal);
                }
                {
                    this.setFlags(newVal, ok);
                    return;
                }
            }
            catch (Exception ex) {
                throw new CPUException(String.format("Illegal CAS access of %08x", addr));
            }
        }
        throw new CPUException("CAS form not implemented");
    }

    private void opENDIAN(Decoded d) {
        if (d.tt == 0) {
            int count = d.getArgCount();
            if (count != 2) {
                throw new CPUException("ENDIAN must have two arguments");
            }
            boolean littleEndian = this.getO(d.b, d.v1) != 0L;
            PortHandler ph = this.getPortHandler((int)this.getO(d.a, d.v0));
            if (ph != null) {
                ph.setLittleEndian(littleEndian);
            }
        }
    }

    public void opSAVE(Decoded d) {
        int count;
        if (d.tt == 0 && ((count = d.getArgCount()) == 1 || count == 2)) {
            if (d.a != d.b) {
                throw new CPUException("SAVE operands must be same type");
            }
            if (Simulator.isRegKind(d.a)) {
                if (count == 1) {
                    d.v1 = 28;
                }
                for (int i = d.v0; i <= d.v1; ++i) {
                    this.push(this.R[i]);
                }
                return;
            }
            if (Simulator.isFPKind(d.a)) {
                if (count == 1) {
                    d.v1 = 31;
                }
                for (int i = d.v0; i <= d.v1; ++i) {
                    this.fpush(this.F[i]);
                }
                return;
            }
        }
        throw new CPUException("SAVE form not implemented");
    }

    public void opRESTORE(Decoded d) {
        int count;
        if (d.tt == 0 && ((count = d.getArgCount()) == 1 || count == 2)) {
            if (d.a != d.b) {
                throw new CPUException("RESTORE operands must be same type");
            }
            if (Simulator.isRegKind(d.a)) {
                if (count == 1) {
                    d.v1 = 28;
                }
                for (int i = d.v1; i >= d.v0; --i) {
                    this.R[i] = this.pop();
                }
                return;
            }
            if (Simulator.isFPKind(d.a)) {
                if (count == 1) {
                    d.v1 = 31;
                }
                for (int i = d.v1; i >= d.v0; --i) {
                    this.F[i] = this.fpop();
                }
                return;
            }
        }
        throw new CPUException("RESTORE form not implemented");
    }

    private void opREADONLY(Decoded d) {
        if (d.tt == 1) {
            this.protect(this.R[31], d.c1);
            return;
        }
        throw new CPUException("READONLY form not implemented");
    }

    public long getPID() {
        return this.pid;
    }

    public long nextPID() {
        return nextPID.getAndIncrement();
    }

    public Vector<Long> getChildPIDs() {
        return this.childCPUs.stream().map(x -> x.getPID()).collect(Collectors.toCollection(Vector::new));
    }

    public static Vector<Long> getThreadPIDs() {
        return threadCPUs.stream().map(x -> x.getPID()).collect(Collectors.toCollection(Vector::new));
    }

    public synchronized Simulator getChildCPU(int pid) {
        for (Simulator child : this.childCPUs) {
            if (child.getPID() != (long)pid) continue;
            return child;
        }
        return null;
    }

    public static synchronized Simulator getThreadCPU(int pid) {
        for (Simulator thread : threadCPUs) {
            if (thread.getPID() != (long)pid) continue;
            return thread;
        }
        return null;
    }

    public ChildProcess getProcess() {
        return this.process;
    }

    public ChildThread getThread() {
        return this.thread;
    }

    public long getClock() {
        return System.nanoTime() - this.startClock;
    }

    public long getCycles() {
        return this.cycles;
    }

    public long getSystemClock() {
        return this.totalSystemTime;
    }

    public int getCommandLineCount() {
        return this.args.length;
    }

    public String getCommandLineArg(int i) {
        return this.args[i];
    }

    public void setSP(long sp) {
        this.R[30] = sp;
    }

    public void setSF(long sf) {
        this.R[29] = sf;
    }

    public void setPC(long pc) {
        this.R[31] = pc;
    }

    public void setDebug(boolean on) {
        this.debug = on;
    }

    public void setTrace(boolean on) {
        this.trace = on;
    }

    public long getR(int r) {
        return this.R[r & 0x1F];
    }

    public void setR(int r, long v) {
        this.R[r & 0x1F] = v;
        this.setFlags(v, false);
    }

    public double getFP(int f) {
        return this.F[f & 0x1F];
    }

    public void setFP(int f, double v) {
        this.F[f & 0x1F] = v;
        this.setFlags(v);
    }

    public void push(long val) {
        this.memWrite(this.R[30], val);
        this.R[30] = this.R[30] - 1L;
    }

    public long pop() {
        this.R[30] = this.R[30] + 1L;
        return this.memRead(this.R[30]);
    }

    public void fpush(double val) {
        this.memWrite(this.R[30], Double.doubleToRawLongBits(val));
        this.R[30] = this.R[30] - 1L;
    }

    public double fpop() {
        this.R[30] = this.R[30] + 1L;
        return Double.longBitsToDouble(this.memRead(this.R[30]));
    }

    public void protect(long addr, long limit) throws CPUException {
        if (addr < 0L || addr > this.heapStart) {
            throw new CPUException("Illegal protect base addr at " + addr);
        }
        if (limit < addr || limit > this.heapStart) {
            throw new CPUException("Illegal protect limit at " + limit);
        }
        this.protectedMemory.add(new Pair<Long, Long>(addr, limit));
    }

    private static long fibonacciSize(long size) {
        int i;
        for (i = 0; i < fibonacci.length && fibonacci[i] < size; ++i) {
        }
        return i == fibonacci.length ? size : fibonacci[i];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long alloc(long requestedWords) throws CPUException {
        long start = System.nanoTime();
        if (this.freeList.isEmpty()) {
            return 0L;
        }
        long p = 0L;
        boolean found = false;
        long[] lArray = this.mem;
        synchronized (this.mem) {
            if (requestedWords < 1L || requestedWords > 0x7FFFFFFCL) {
                throw new CPUException("Illegal memory allocation: " + requestedWords);
            }
            long numWords = requestedWords;
            numWords = Simulator.fibonacciSize(numWords + 3L);
            Iterator it = this.freeList.iterator();
            while (it.hasNext()) {
                p = (Long)it.next();
                long size = this.memRead(p + 2L);
                if (size >= 0L || -size < numWords) continue;
                if (-size - numWords < fibonacci[0]) {
                    this.memWrite(p + 2L, -size);
                    it.remove();
                    found = true;
                    break;
                }
                long new_p = p + numWords;
                this.memWrite(new_p, p);
                this.memWrite(new_p + 1L, this.memRead(p + 1L));
                this.memWrite(new_p + 2L, size + numWords);
                this.memWrite(p + 1L, new_p);
                this.memWrite(p + 2L, numWords);
                it.remove();
                this.freeList.push(new_p);
                found = true;
                break;
            }
            // ** MonitorExit[var8_5] (shouldn't be in output)
            long stop = System.nanoTime();
            this.totalSystemTime += stop - start;
            return found ? p + 3L : 0L;
        }
    }

    public long realloc(long oldAddr, long newSize) {
        long start = System.nanoTime();
        long newAddr = oldAddr;
        long oldSize = this.memRead(oldAddr - 1L);
        if (oldSize < (newSize = Simulator.fibonacciSize(newSize + 3L))) {
            newAddr = this.alloc(newSize - 3L);
            if (newAddr != 0L) {
                this.memmove(newAddr, oldAddr, oldSize - 3L);
                this.free(oldAddr);
            }
        } else if (oldSize > newSize && (newAddr = this.alloc(newSize - 3L)) != 0L) {
            this.memmove(newAddr, oldAddr, newSize - 3L);
            this.free(oldAddr);
        }
        long stop = System.nanoTime();
        this.totalSystemTime += stop - start;
        return newAddr;
    }

    private void combineBlocks(long p) {
        long nextSize;
        if (p <= 0L) {
            return;
        }
        long size = this.memRead(p + 2L);
        if (size >= 0L) {
            return;
        }
        long prev = this.memRead(p);
        long next = this.memRead(p + 1L);
        if (next > 0L && (nextSize = this.memRead(next + 2L)) < 0L) {
            this.memWrite(p + 2L, nextSize + size);
            long next_next = this.memRead(next + 1L);
            this.memWrite(p + 1L, next_next);
            if (next_next > 0L) {
                this.memWrite(next_next, p);
            }
            this.memWrite(next, -1L);
            this.memWrite(next + 1L, -1L);
            this.memWrite(next + 2L, 0L);
            this.freeList.remove(next);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free(long address) {
        long start = System.nanoTime();
        long[] lArray = this.mem;
        synchronized (this.mem) {
            long p = address - 3L;
            if (p <= 0L) {
                // ** MonitorExit[var5_3] (shouldn't be in output)
                return;
            }
            long size = this.memRead(p + 2L);
            if (size <= 0L) {
                // ** MonitorExit[var5_3] (shouldn't be in output)
                return;
            }
            this.memWrite(p + 2L, -size);
            this.freeList.push(p);
            this.combineBlocks(p);
            this.combineBlocks(this.memRead(p));
            // ** MonitorExit[var5_3] (shouldn't be in output)
            long stop = System.nanoTime();
            this.totalSystemTime += stop - start;
            return;
        }
    }

    public long countHeapBlocks(boolean countAlloc, boolean countFree) {
        long p = this.heapStart;
        long numAlloc = 0L;
        long numFree = 0L;
        while (p > 0L) {
            if (this.memRead(p + 2L) < 0L) {
                ++numFree;
            } else {
                ++numAlloc;
            }
            p = this.memRead(p + 1L);
        }
        if (countAlloc && countFree) {
            return numAlloc + numFree;
        }
        if (countAlloc) {
            return numAlloc;
        }
        if (countFree) {
            return numFree;
        }
        return 0L;
    }

    public long countHeapSize(boolean countAlloc, boolean countFree) {
        long p = this.heapStart;
        long numAlloc = 0L;
        long numFree = 0L;
        while (p > 0L) {
            long size = this.memRead(p + 2L);
            if (size < 0L) {
                numFree += -size;
            } else {
                numAlloc += size;
            }
            p = this.memRead(p + 1L);
        }
        if (countAlloc && countFree) {
            return numAlloc + numFree;
        }
        if (countAlloc) {
            return numAlloc;
        }
        if (countFree) {
            return numFree;
        }
        return 0L;
    }

    public void walkHeap() {
        long p = this.heapStart;
        long numAlloc = 0L;
        long numFree = 0L;
        System.out.printf("Heap Blocks:\n", new Object[0]);
        while (p > 0L) {
            long size = this.memRead(p + 2L);
            System.out.printf("%08x: %d\n", p, size);
            p = this.memRead(p + 1L);
        }
    }

    public void memmove(long dest, long src, long size) {
        long start = System.nanoTime();
        if (dest < 0L || dest > (long)this.mem.length) {
            throw new CPUException("Illegal memmove dest argument!");
        }
        if (src < 0L || src > (long)this.mem.length) {
            throw new CPUException("Illegal memmove src argument!");
        }
        if (src + size > (long)this.mem.length || dest + size > (long)this.mem.length) {
            throw new CPUException("Illegal memmove size argument!");
        }
        System.arraycopy(this.mem, (int)src, this.mem, (int)dest, (int)size);
        long stop = System.nanoTime();
        this.totalSystemTime += stop - start;
    }

    public void memclear(long src, long size) {
        long start = System.nanoTime();
        if (src < 0L || src > (long)this.mem.length) {
            throw new CPUException("Illegal memclear src argument!");
        }
        if (src + size > (long)this.mem.length) {
            throw new CPUException("Illegal memclear size argument!");
        }
        Arrays.fill(this.mem, (int)src, (int)(src + size), 0L);
        long stop = System.nanoTime();
        this.totalSystemTime += stop - start;
    }

    public long allocString(String s) {
        return this.allocString(s, 0L);
    }

    public long allocString(String s, long allocBuffer) {
        long result;
        byte[] utf8 = s.getBytes(StandardCharsets.UTF_8);
        long neededWords = (utf8.length + 7) / 8 + 1;
        if (allocBuffer <= 0L) {
            result = this.alloc(neededWords);
        } else if (this.memRead(allocBuffer - 1L) - 3L >= neededWords) {
            result = allocBuffer;
        } else {
            this.free(allocBuffer);
            result = this.alloc(neededWords);
        }
        if (result != 0L) {
            long p = result;
            this.memWrite(p++, utf8.length);
            long buffer = 0L;
            int index = 7;
            for (byte c : utf8) {
                buffer |= ((long)c & 0xFFL) << index * 8;
                if (--index >= 0) continue;
                this.memWrite(p++, buffer);
                buffer = 0L;
                index = 7;
            }
            if (index != 7) {
                this.memWrite(p, buffer);
            }
        }
        return result;
    }

    public String convertString(long addr) {
        long byteCount;
        if (addr < 0L) {
            throw new CPUException("Illegal string address");
        }
        if ((byteCount = this.memRead(addr++)) < 0L || byteCount > Integer.MAX_VALUE) {
            throw new CPUException("Invalid UTF-8 byte count: " + byteCount);
        }
        byte[] bytes = new byte[(int)byteCount];
        int outIndex = 0;
        while ((long)outIndex < byteCount) {
            long w = this.memRead(addr);
            for (int b = 7; b >= 0 && (long)outIndex < byteCount; --b) {
                bytes[outIndex++] = (byte)(w >> b * 8 & 0xFFL);
            }
            ++addr;
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long fork() throws CPUException {
        try {
            Simulator childCPU = new Simulator(this, true);
            childCPU.setR(31, childCPU.getR(31) + 1L);
            childCPU.setR(0, 0L);
            ChildProcess child = new ChildProcess(childCPU, this);
            Vector<Simulator> vector = this.childCPUs;
            synchronized (vector) {
                this.childCPUs.add(childCPU);
            }
            child.fork();
            return childCPU.getPID();
        }
        catch (Exception ex) {
            return -1L;
        }
    }

    public void waitAll() throws CPUException {
        Vector<Long> pids = this.getChildPIDs();
        for (Long pid : pids) {
            this.waitPID(pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitPID(long pid) {
        ChildProcess p;
        Simulator childCPU = this.getChildCPU((int)pid);
        if (childCPU != null && (p = childCPU.getProcess()) != null) {
            p.join();
            Vector<Simulator> vector = this.childCPUs;
            synchronized (vector) {
                this.childCPUs.remove(childCPU);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long thread(long function, long data) throws CPUException {
        try {
            Simulator threadCPU = new Simulator(this, false);
            threadCPU.push(data);
            threadCPU.push(-1L);
            threadCPU.push(threadCPU.getR(29));
            threadCPU.setR(29, threadCPU.getR(30));
            threadCPU.setR(31, function);
            ChildThread child = new ChildThread(threadCPU);
            Vector<Simulator> vector = threadCPUs;
            synchronized (vector) {
                threadCPUs.add(threadCPU);
            }
            child.start();
            return threadCPU.getPID();
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinThread(long pid) {
        ChildThread t;
        Simulator threadCPU = Simulator.getThreadCPU((int)pid);
        if (threadCPU != null && (t = threadCPU.getThread()) != null) {
            try {
                t.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Vector<Simulator> vector = threadCPUs;
            synchronized (vector) {
                threadCPUs.remove(threadCPU);
            }
        }
    }

    public void wakeThread(long pid) {
        ChildThread t;
        Simulator threadCPU = Simulator.getThreadCPU((int)pid);
        if (threadCPU != null && (t = threadCPU.getThread()) != null) {
            t.interrupt();
        }
    }

    public static synchronized long allocShared(long allocSize) {
        int newAlloc = sharedMem.size();
        sharedMem.setSize(newAlloc + (int)allocSize);
        return Long.MIN_VALUE + (long)newAlloc;
    }

    public PortHandler getPortHandler(int port) {
        PortHandler ph = this.ports.get(port);
        if (ph != null) {
            ph.setPort(port);
        }
        return ph;
    }

    public void setPortHandler(int port, PortHandler ph) {
        this.ports.put(port, ph);
    }

    public void exit(int code) {
        this.setR(0, code);
        this.running = false;
    }

    public void printCPUState() {
        System.out.printf("\nCPU State    SR: %s\n", this.formatSR());
        System.out.printf(fmtHeading, cpuLabels);
        int stack_base = (int)this.R[30] + 32;
        if ((long)stack_base >= this.stackBase) {
            stack_base = (int)this.stackBase - 1;
        }
        for (int i = 0; i < 32; ++i) {
            if (i >= 29) {
                System.out.printf(fmtCPUAlt, registers[i], this.R[i], registersFP[i], this.F[i]);
            } else {
                System.out.printf(fmtCPU, registers[i], this.R[i], this.R[i], registersFP[i], this.F[i]);
            }
            if ((long)(stack_base - i) > this.R[30]) {
                long v = this.memRead(stack_base - i);
                double f = Double.longBitsToDouble(v);
                System.out.printf(fmtStack, (long)(stack_base - i) == this.R[29] ? "=>" : "  ", (long)(stack_base - i) - this.R[30], v, v, f);
            } else if ((long)(stack_base - i) == this.R[30] && (long)(stack_base - i) == this.R[29]) {
                System.out.print(" =>");
            }
            System.out.println("");
        }
        System.out.flush();
    }

    public static String formatAddress(long addr) {
        return String.format(fmtAddress, (int)addr);
    }

    public static String formatWord(long x) {
        return String.format(fmtHex, x);
    }

    public static long encT0(int op, int a, int b, int c, int d, int v0, int v1, int v2, int v3) {
        long w = 0L;
        w |= 0L;
        w |= ((long)op & 0x3FL) << 56;
        w |= ((long)a & 3L) << 54;
        w |= ((long)b & 3L) << 52;
        w |= ((long)c & 3L) << 50;
        w |= ((long)d & 3L) << 48;
        w |= ((long)v0 & 0xFFFL) << 36;
        w |= ((long)v1 & 0xFFFL) << 24;
        w |= ((long)v2 & 0xFFFL) << 12;
        return w |= (long)v3 & 0xFFFL;
    }

    public static long encT1(int op, long imm56) {
        long w = 0L;
        w |= 0x4000000000000000L;
        w |= ((long)op & 0x3FL) << 56;
        return w |= imm56 & 0xFFFFFFFFFFFFFFL;
    }

    public static long encT2(int op, int aKind, int v0, long imm42) {
        long w = 0L;
        w |= Long.MIN_VALUE;
        w |= ((long)op & 0x3FL) << 56;
        w |= ((long)aKind & 3L) << 54;
        w |= ((long)v0 & 0xFFFL) << 42;
        return w |= imm42 & 0x3FFFFFFFFFFL;
    }

    public static long encT3(int op, int aKind, int bKind, int v0, int v1, int imm28) {
        long w = 0L;
        w |= 0xC000000000000000L;
        w |= ((long)op & 0x3FL) << 56;
        w |= ((long)aKind & 3L) << 54;
        w |= ((long)bKind & 3L) << 52;
        w |= ((long)v0 & 0xFFFL) << 40;
        w |= ((long)v1 & 0xFFFL) << 28;
        return w |= (long)imm28 & 0xFFFFFFFL;
    }

    public CPUState getState() {
        return new CPUState(this);
    }

    public List<String> diffState(CPUState start) {
        int i;
        ArrayList<String> diffs = new ArrayList<String>();
        CPUState end = this.getState();
        for (i = 0; i < 32; ++i) {
            if (start.R[i] == end.R[i]) continue;
            if (i == 29) {
                diffs.add("SF:" + end.R[29]);
                continue;
            }
            if (i == 30) {
                diffs.add("SP:" + end.R[30]);
                continue;
            }
            if (i == 31) {
                diffs.add("PC:" + end.R[31]);
                continue;
            }
            diffs.add("R" + i + ":" + end.R[i]);
        }
        for (i = 0; i < 32; ++i) {
            if (start.F[i] == end.F[i]) continue;
            diffs.add("F" + i + ":" + end.F[i]);
        }
        if (start.SR != end.SR) {
            diffs.add("SR:" + end.SR);
        }
        return diffs;
    }

    public static Map<String, Long> readLabelMapFromFile(File filename) {
        HashMap<String, Long> labelMap;
        block11: {
            labelMap = new HashMap<String, Long>();
            try {
                BufferedReader reader = new BufferedReader(new FileReader(filename));
                block9: while (true) {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        int colon;
                        if ((line = line.trim()).isEmpty() || line.startsWith("#") || (colon = line.indexOf(58)) == -1) continue;
                        String key = line.substring(0, colon).trim();
                        String valStr = line.substring(colon + 1).trim();
                        try {
                            long value = Long.parseLong(valStr);
                            labelMap.put(key, value);
                            continue block9;
                        }
                        catch (NumberFormatException e) {
                            System.err.println("Skipping invalid line: " + line);
                        }
                    }
                    break block11;
                    {
                        continue block9;
                        break;
                    }
                    break;
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException e) {
                System.err.println("Error reading label map: " + e.getMessage());
            }
        }
        return labelMap;
    }

    public static Map<Long, String> readReverseLabelMapFromFile(File filename) {
        HashMap<Long, String> labelMap;
        block11: {
            labelMap = new HashMap<Long, String>();
            try {
                BufferedReader reader = new BufferedReader(new FileReader(filename));
                block9: while (true) {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        int colon;
                        if ((line = line.trim()).isEmpty() || line.startsWith("#") || (colon = line.indexOf(58)) == -1) continue;
                        String keyStr = line.substring(0, colon).trim();
                        String valStr = line.substring(colon + 1).trim();
                        try {
                            long key = Long.parseLong(keyStr);
                            labelMap.put(key, valStr);
                            continue block9;
                        }
                        catch (NumberFormatException e) {
                            System.err.println("Skipping invalid line: " + line);
                        }
                    }
                    break block11;
                    {
                        continue block9;
                        break;
                    }
                    break;
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException e) {
                System.err.println("Error reading reverse label map: " + e.getMessage());
            }
        }
        return labelMap;
    }

    public static Map<String, LabelType> readLabelTypesFromFile(File filename) {
        HashMap<String, LabelType> labelTypes;
        block11: {
            labelTypes = new HashMap<String, LabelType>();
            try {
                BufferedReader reader = new BufferedReader(new FileReader(filename));
                block9: while (true) {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        int colon;
                        if ((line = line.trim()).isEmpty() || line.startsWith("#") || (colon = line.indexOf(58)) == -1) continue;
                        String key = line.substring(0, colon).trim();
                        String valStr = line.substring(colon + 1).trim();
                        try {
                            LabelType value = LabelType.valueOf(valStr);
                            labelTypes.put(key, value);
                            continue block9;
                        }
                        catch (NumberFormatException e) {
                            System.err.println("Skipping invalid line: " + line);
                        }
                    }
                    break block11;
                    {
                        continue block9;
                        break;
                    }
                    break;
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException e) {
                System.err.println("Error reading label type map: " + e.getMessage());
            }
        }
        return labelTypes;
    }

    static {
        int i;
        sharedMem = new LongArray(1024);
        nextPID = new AtomicLong(1L);
        threadCPUs = new Vector();
        padHex = String.format("%16s", "");
        padDec = String.format("%21s", "");
        fmtCPUAlt = "%3s: %016x " + padDec + " %3s: %23.16g";
        cpuLabels = new String[]{"R", "hex", "dec", "FP", "float", "Stack", "hex", "dec", "float"};
        registers = new String[32];
        registersFP = new String[32];
        for (i = 0; i < 29; ++i) {
            Simulator.registers[i] = "R" + i;
        }
        Simulator.registers[29] = "SF";
        Simulator.registers[30] = "SP";
        Simulator.registers[31] = "PC";
        for (i = 0; i < 32; ++i) {
            Simulator.registersFP[i] = "F" + i;
        }
        condition = new String[]{"u", "z", "nz", "n", "p", "nn", "np", "o", "no", "pe", "po"};
        fibonacci = new long[]{8L, 13L, 21L, 34L, 55L, 89L, 144L, 233L, 377L, 610L, 987L, 1597L, 2584L, 4181L, 6765L, 10946L, 17711L, 28657L, 46368L, 75025L, 121393L, 196418L, 317811L, 514229L, 832040L, 1346269L, 2178309L, 3524578L, 5702887L, 0x8CCCC9L, 14930352L, 24157817L, 39088169L, 63245986L, 102334155L, 165580141L, 267914296L, 433494437L, 701408733L, 1134903170L, 1836311903L};
    }

    public static class ChildProcess
    extends RecursiveAction {
        Simulator cpu;
        Simulator parentCPU;

        public ChildProcess(Simulator cpu, Simulator parent) {
            this.cpu = cpu;
            this.cpu.process = this;
            this.parentCPU = parent;
        }

        @Override
        protected void compute() {
            this.cpu.run(this.cpu.getR(31));
        }
    }

    public static class ChildThread
    extends Thread {
        Simulator cpu;

        public ChildThread(Simulator cpu) {
            this.cpu = cpu;
            this.cpu.thread = this;
        }

        @Override
        public void run() {
            try {
                this.cpu.run(this.cpu.getR(31));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public class CPUException
    extends RuntimeException {
        CPUException(String msg) {
            super(String.format("PC:%08x -> ", Simulator.this.R[31]) + msg);
        }

        CPUException(String msg, Object ... args) {
            super(String.format("PC:%08x -> " + msg, Simulator.this.R[31], args));
        }
    }

    public record Pair<A, B>(A first, B second) {
    }

    public static final class Decoded {
        public int tt;
        int op;
        public int a;
        public int b;
        public int c;
        public int d;
        public int v0;
        public int v1;
        public int v2;
        public int v3;
        public long c1;
        long c2;
        int c3;
        static long maxLabel = -1L;

        public static Decoded decode(long w) {
            Decoded d = new Decoded();
            d.tt = (int)(w >>> 62 & 3L);
            d.op = (int)(w >>> 56 & 0x3FL);
            switch (d.tt) {
                case 0: {
                    d.a = (int)(w >>> 54 & 3L);
                    d.b = (int)(w >>> 52 & 3L);
                    d.c = (int)(w >>> 50 & 3L);
                    d.d = (int)(w >>> 48 & 3L);
                    d.v0 = (int)(w >>> 36 & 0xFFFL);
                    d.v1 = (int)(w >>> 24 & 0xFFFL);
                    d.v2 = (int)(w >>> 12 & 0xFFFL);
                    d.v3 = (int)(w & 0xFFFL);
                    if (Simulator.isConstKind(d.a)) {
                        d.v0 = (int)Simulator.signExtend(d.v0, 12);
                    }
                    if (Simulator.isConstKind(d.b)) {
                        d.v1 = (int)Simulator.signExtend(d.v1, 12);
                    }
                    if (Simulator.isConstKind(d.c)) {
                        d.v2 = (int)Simulator.signExtend(d.v2, 12);
                    }
                    if (!Simulator.isConstKind(d.d)) break;
                    d.v3 = (int)Simulator.signExtend(d.v3, 12);
                    break;
                }
                case 1: {
                    long imm = w & 0xFFFFFFFFFFFFFFL;
                    d.c1 = Simulator.signExtend(imm, 56);
                    break;
                }
                case 2: {
                    d.a = (int)(w >>> 54 & 3L);
                    d.v0 = (int)(w >>> 42 & 0xFFFL);
                    long imm = w & 0x3FFFFFFFFFFL;
                    d.c2 = Simulator.signExtend(imm, 42);
                    break;
                }
                case 3: {
                    d.a = (int)(w >>> 54 & 3L);
                    d.b = (int)(w >>> 52 & 3L);
                    d.v0 = (int)(w >>> 40 & 0xFFFL);
                    d.v1 = (int)(w >>> 28 & 0xFFFL);
                    int raw = (int)(w & 0xFFFFFFFL);
                    d.c3 = (int)Simulator.signExtend(raw, 28);
                }
            }
            return d;
        }

        public int getArgCount() {
            int count = 0;
            switch (this.tt) {
                case 0: {
                    if (Simulator.isNoneKind(this.a)) {
                        count = 0;
                        break;
                    }
                    if (Simulator.isNoneKind(this.b)) {
                        count = 1;
                        break;
                    }
                    if (Simulator.isNoneKind(this.c)) {
                        count = 2;
                        break;
                    }
                    if (Simulator.isNoneKind(this.d)) {
                        count = 3;
                        break;
                    }
                    count = 4;
                    break;
                }
                case 1: {
                    count = 1;
                    break;
                }
                case 2: {
                    count = 2;
                    break;
                }
                case 3: {
                    count = 3;
                }
            }
            return count;
        }

        public static String getRegisterOrValue(int type, long num) {
            return switch (type) {
                case 0 -> "None";
                case 1 -> Long.toString(num);
                case 2 -> registers[(int)num];
                case 3 -> registersFP[(int)num];
                default -> throw new RuntimeException("Unexpected op type: " + type);
            };
        }

        public String get(int i) {
            switch (i) {
                case 0: {
                    return Decoded.getRegisterOrValue(this.a, this.v0);
                }
                case 1: {
                    return Decoded.getRegisterOrValue(this.b, this.v1);
                }
                case 2: {
                    return Decoded.getRegisterOrValue(this.c, this.v2);
                }
                case 3: {
                    return Decoded.getRegisterOrValue(this.d, this.v3);
                }
            }
            throw new RuntimeException("Illegal op index: " + i);
        }

        public int getType() {
            return this.tt;
        }

        public int getOpCode() {
            return this.op;
        }

        public String getOpName() {
            if (this.op == Opcode.NOP.getCode() && this.getArgCount() == 0) {
                return Opcode.NOP.getName();
            }
            return Opcode.fromCode(this.op).getName();
        }

        public String disassemble(Map<Long, String> reverseSymbolMap) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(String.format("%-10s\t", this.getOpName()));
            switch (this.getType()) {
                case 0: {
                    if (this.a == 0) break;
                    String v0 = this.get(0);
                    buffer.append(v0);
                    if (this.b == 0) break;
                    buffer.append(", ");
                    String v1 = this.get(1);
                    buffer.append(v1);
                    if (this.c == 0) break;
                    buffer.append(", ");
                    String v2 = this.get(2);
                    buffer.append(v2);
                    if (this.d == 0) break;
                    buffer.append(", ");
                    String v3 = this.get(3);
                    buffer.append(v3);
                    break;
                }
                case 1: {
                    Object v0;
                    if (this.getOpCode() == Opcode.JUMP.code || this.getOpCode() == Opcode.CALL.code || this.getOpCode() == Opcode.READONLY.code) {
                        v0 = "0x" + Long.toString(this.c1, 16);
                        String label = Decoded.findNearestLabel(reverseSymbolMap, this.c1);
                        if (label != null) {
                            v0 = (String)v0 + " (" + label + ")";
                        }
                    } else {
                        v0 = Long.toString(this.c1);
                    }
                    buffer.append((String)v0);
                    break;
                }
                case 2: {
                    Object v1;
                    String v0 = this.get(0);
                    if (this.a == 1 && (this.getOpCode() == Opcode.JUMP.code || this.getOpCode() == Opcode.CALL.code)) {
                        v0 = condition[this.v0];
                    }
                    buffer.append(v0);
                    buffer.append(", ");
                    if (this.getOpCode() == Opcode.JUMP.code || this.getOpCode() == Opcode.CALL.code) {
                        v1 = "0x" + Long.toString(this.c2, 16);
                        String label = Decoded.findNearestLabel(reverseSymbolMap, this.c2);
                        if (label != null) {
                            v1 = (String)v1 + " (" + label + ")";
                        }
                    } else {
                        v1 = Long.toString(this.c2);
                    }
                    buffer.append((String)v1);
                    break;
                }
                case 3: {
                    String v0 = this.get(0);
                    if (this.a == 1 && (this.getOpCode() == Opcode.JUMP.code || this.getOpCode() == Opcode.CALL.code)) {
                        v0 = condition[this.v0];
                    }
                    buffer.append(v0);
                    buffer.append(", ");
                    String v1 = this.get(1);
                    buffer.append(v1);
                    buffer.append(", ");
                    Object v2 = this.getOpCode() == Opcode.JUMP.code || this.getOpCode() == Opcode.CALL.code ? "0x" + Long.toString(this.c3, 16) : Integer.toString(this.c3);
                    buffer.append((String)v2);
                }
            }
            return buffer.toString();
        }

        public static String findNearestLabel(Map<Long, String> reverseSymbolMap, long loc) {
            if (reverseSymbolMap == null || reverseSymbolMap.size() == 0) {
                return null;
            }
            if (maxLabel < 0L) {
                for (Long i : reverseSymbolMap.keySet()) {
                    if (i <= maxLabel) continue;
                    maxLabel = i;
                }
            }
            long j = loc > maxLabel ? maxLabel : loc;
            Object label = reverseSymbolMap.get(j);
            while (label == null && j > 0L) {
                label = reverseSymbolMap.get(--j);
            }
            label = (String)label + "+" + (loc - j);
            return label;
        }
    }

    public static enum LabelType {
        CODE,
        CHAR,
        INT,
        HEX,
        FLOAT,
        STRING;

    }

    public final class CPUState {
        long[] R = new long[32];
        double[] F = new double[32];
        long SR;
        long cycles;

        public CPUState(Simulator this$0) {
            int i;
            for (i = 0; i < 32; ++i) {
                this.R[i] = this$0.R[i];
            }
            for (i = 0; i < 32; ++i) {
                this.F[i] = this$0.F[i];
            }
            this.SR = this$0.SR;
            this.cycles = this$0.cycles;
        }
    }
}

