/*
 * Decompiled with CFR 0.152.
 */
package cloud.lesh.CPUSim64;

import cloud.lesh.CPUSim64.PortHandler;
import cloud.lesh.CPUSim64.Simulator;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class StdIOPortHandler
extends PortHandler {
    static int lastPort = 0;
    static InputStreamReader reader = new InputStreamReader(System.in);

    public StdIOPortHandler(Simulator cpu) {
        super(cpu);
    }

    @Override
    public int read() throws Simulator.CPUException {
        if (this.port() != 0) {
            Simulator simulator = this.cpu;
            Objects.requireNonNull(simulator);
            throw simulator.new Simulator.CPUException("Can't read from STDOUT or STDERR!");
        }
        try {
            return System.in.read();
        }
        catch (Exception e) {
            Simulator simulator = this.cpu;
            Objects.requireNonNull(simulator);
            throw simulator.new Simulator.CPUException("Read error on port " + this.port() + "!");
        }
    }

    @Override
    public int readChar() throws Simulator.CPUException {
        if (this.port() != 0) {
            Simulator simulator = this.cpu;
            Objects.requireNonNull(simulator);
            throw simulator.new Simulator.CPUException("Can't read from STDOUT or STDERR!");
        }
        int codePoint = -1;
        try {
            int ch1 = reader.read();
            if (ch1 != -1) {
                char c1 = (char)ch1;
                if (Character.isHighSurrogate(c1)) {
                    int ch2 = reader.read();
                    if (ch2 != -1) {
                        char c2 = (char)ch2;
                        if (Character.isLowSurrogate(c2)) {
                            codePoint = Character.toCodePoint(c1, c2);
                        } else {
                            codePoint = c1;
                            reader.reset();
                        }
                    } else {
                        codePoint = c1;
                    }
                } else {
                    codePoint = c1;
                }
            }
        }
        catch (Exception e) {
            Simulator simulator = this.cpu;
            Objects.requireNonNull(simulator);
            throw simulator.new Simulator.CPUException("Read error on STDIN!");
        }
        return codePoint;
    }

    @Override
    public void write(byte x) throws Simulator.CPUException {
        if (this.port() == 0) {
            Simulator simulator = this.cpu;
            Objects.requireNonNull(simulator);
            throw simulator.new Simulator.CPUException("Can't write to STDIN!");
        }
        try {
            if (this.port() != lastPort) {
                lastPort = this.port();
                System.out.flush();
                System.err.flush();
            }
            if (this.port() == 2) {
                System.err.write(x);
            } else {
                System.out.write(x);
            }
        }
        catch (Exception e) {
            Simulator simulator = this.cpu;
            Objects.requireNonNull(simulator);
            throw simulator.new Simulator.CPUException("Write error on port " + this.port() + "!");
        }
    }

    @Override
    public void writeChar(int codePoint) throws Simulator.CPUException {
        if (this.port() == 0) {
            Simulator simulator = this.cpu;
            Objects.requireNonNull(simulator);
            throw simulator.new Simulator.CPUException("Can't write to STDIN!");
        }
        try {
            if (this.port() != lastPort) {
                lastPort = this.port();
                System.out.flush();
                System.err.flush();
            }
            if (this.port() == 2) {
                String s = new String(Character.toChars(codePoint));
                byte[] utf8 = s.getBytes(StandardCharsets.UTF_8);
                System.err.write(utf8);
            } else {
                String s = new String(Character.toChars(codePoint));
                byte[] utf8 = s.getBytes(StandardCharsets.UTF_8);
                System.out.write(utf8);
            }
        }
        catch (Exception e) {
            Simulator simulator = this.cpu;
            Objects.requireNonNull(simulator);
            throw simulator.new Simulator.CPUException("Write error on port " + this.port() + "!");
        }
    }

    @Override
    public void flush() throws Simulator.CPUException {
        if (this.port() == 0) {
            Simulator simulator = this.cpu;
            Objects.requireNonNull(simulator);
            throw simulator.new Simulator.CPUException("Can't write to STDIN!");
        }
        try {
            if (this.port() == 2) {
                System.err.flush();
            } else {
                System.out.flush();
            }
        }
        catch (Exception e) {
            Simulator simulator = this.cpu;
            Objects.requireNonNull(simulator);
            throw simulator.new Simulator.CPUException("Flush error on port " + this.port() + "!");
        }
    }

    @Override
    public void close() throws Simulator.CPUException {
        Simulator simulator = this.cpu;
        Objects.requireNonNull(simulator);
        throw simulator.new Simulator.CPUException("Can't close STDIO or STDERR!");
    }
}

