/*
 * Decompiled with CFR 0.152.
 */
package cloud.lesh.CPUSim64;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class Utils {
    private static final Pattern LINE_PATTERN = Pattern.compile("^\\.(LINE|LINE_BEGIN)\\s+(.*)$");

    public static double asinh(double x) {
        return Math.log(x + Math.sqrt(x * x + 1.0));
    }

    public static double acosh(double x) {
        return Math.log(x + Math.sqrt(x * x - 1.0));
    }

    public static double atanh(double x) {
        return 0.5 * Math.log((1.0 + x) / (1.0 - x));
    }

    public static int decodeSI(String s) {
        if (s == null) {
            throw new IllegalArgumentException("null input");
        }
        if ((s = s.trim()).isEmpty()) {
            throw new IllegalArgumentException("empty input");
        }
        int len = s.length();
        char last = s.charAt(len - 1);
        double multiplier = 1.0;
        String numberPart = s;
        switch (Character.toUpperCase(last)) {
            case 'K': {
                multiplier = 1000.0;
                numberPart = s.substring(0, len - 1);
                break;
            }
            case 'M': {
                multiplier = 1000000.0;
                numberPart = s.substring(0, len - 1);
                break;
            }
            case 'G': {
                multiplier = 1.0E9;
                numberPart = s.substring(0, len - 1);
                break;
            }
            case 'T': {
                multiplier = 1.0E12;
                numberPart = s.substring(0, len - 1);
                break;
            }
            case 'P': {
                multiplier = 1.0E15;
                numberPart = s.substring(0, len - 1);
                break;
            }
            case 'E': {
                multiplier = 1.0E18;
                numberPart = s.substring(0, len - 1);
                break;
            }
        }
        double value = Double.parseDouble(numberPart.trim());
        double result = Math.round(value * multiplier);
        if (result > 2.147483647E9 || result < 0.0) {
            throw new NumberFormatException("Value out of range for integer: " + s);
        }
        return (int)result;
    }

    public static long parseCharLiteral(String s) {
        if (s.length() >= 2 && s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'') {
            s = s.substring(1, s.length() - 1);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == '\\' && i + 1 < s.length()) {
                char next = s.charAt(i + 1);
                switch (next) {
                    case 'b': {
                        sb.append('\b');
                        ++i;
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        ++i;
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        ++i;
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        ++i;
                        break;
                    }
                    case '\\': {
                        sb.append('\\');
                        ++i;
                        break;
                    }
                    case '\'': {
                        sb.append('\'');
                        ++i;
                        break;
                    }
                    case '\"': {
                        sb.append('\"');
                        ++i;
                        break;
                    }
                    case '0': {
                        sb.append('\u0000');
                        ++i;
                        break;
                    }
                    case 'U': 
                    case 'u': {
                        Pattern p = Pattern.compile("\\{([0-9A-Fa-f]{1,5})\\}");
                        Matcher m = p.matcher(s.substring(i));
                        if (m.find()) {
                            String hex = m.group(1);
                            int codePoint = Integer.parseInt(hex, 16);
                            return codePoint;
                        }
                        sb.append(s);
                        ++i;
                        break;
                    }
                    default: {
                        sb.append(ch);
                        break;
                    }
                }
                continue;
            }
            sb.append(ch);
        }
        String unescaped = sb.toString();
        if (unescaped.length() != 1) {
            throw new IllegalStateException("CHARLIT must be a single character");
        }
        return unescaped.codePointAt(0);
    }

    public static byte[] parseStringLiteral(String str) {
        int[] s = str.codePoints().toArray();
        if (s.length >= 2 && s[0] == 34 && s[s.length - 1] == 34) {
            s = Arrays.copyOfRange(s, 1, s.length - 1);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length; ++i) {
            int ch = s[i];
            if (ch == 92 && i + 1 < s.length) {
                int next = s[++i];
                switch (next) {
                    case 98: {
                        sb.appendCodePoint(8);
                        break;
                    }
                    case 110: {
                        sb.appendCodePoint(10);
                        break;
                    }
                    case 116: {
                        sb.appendCodePoint(9);
                        break;
                    }
                    case 114: {
                        sb.appendCodePoint(13);
                        break;
                    }
                    case 92: {
                        sb.appendCodePoint(92);
                        break;
                    }
                    case 39: {
                        sb.appendCodePoint(39);
                        break;
                    }
                    case 34: {
                        sb.appendCodePoint(34);
                        break;
                    }
                    case 48: {
                        sb.appendCodePoint(0);
                        break;
                    }
                    case 85: 
                    case 117: {
                        StringBuffer hex = new StringBuffer();
                        boolean done = false;
                        block17: while (!done) {
                            next = s[++i];
                            switch (next) {
                                case 123: {
                                    continue block17;
                                }
                                case 48: 
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: 
                                case 56: 
                                case 57: 
                                case 65: 
                                case 66: 
                                case 67: 
                                case 68: 
                                case 69: 
                                case 70: 
                                case 97: 
                                case 98: 
                                case 99: 
                                case 100: 
                                case 101: 
                                case 102: {
                                    hex.appendCodePoint(next);
                                    continue block17;
                                }
                                case 125: {
                                    done = true;
                                    continue block17;
                                }
                            }
                            done = true;
                        }
                        sb.appendCodePoint(Integer.parseInt(hex.toString(), 16));
                        break;
                    }
                    default: {
                        sb.appendCodePoint(ch);
                        break;
                    }
                }
                continue;
            }
            sb.appendCodePoint(ch);
        }
        String unescaped = sb.toString();
        return unescaped.getBytes(StandardCharsets.UTF_8);
    }

    public static String escapeString(String s) {
        s = s.replace("\\", "\\\\");
        s = s.replace("\u0000", "\\0");
        s = s.replace("\b", "\\b");
        s = s.replace("\t", "\\t");
        s = s.replace("\n", "\\n");
        s = s.replace("\r", "\\r");
        s = s.replace("\f", "\\f");
        s = s.replace("\"", "\\\"");
        s = s.replace("'", "\\'");
        return s;
    }

    public static String rebuildWithSingleSpaces(CommonTokenStream tokens, ParserRuleContext ctx) {
        Token start = ctx.getStart();
        Token stop = ctx.getStop();
        if (start == null || stop == null) {
            return "";
        }
        int a = start.getTokenIndex();
        int b = stop.getTokenIndex();
        StringBuilder out = new StringBuilder();
        boolean pendingSpace = false;
        for (int i = a; i <= b; ++i) {
            Token t = tokens.get(i);
            if (t.getChannel() == 1) {
                pendingSpace = true;
                continue;
            }
            if (pendingSpace && out.length() > 0 && t.getText() != ",") {
                out.append(' ');
            }
            pendingSpace = false;
            out.append(t.getText());
        }
        return out.toString().trim();
    }

    public static String rebuildWithSingleSpaces(CommonTokenStream tokens, ParseTree node) {
        if (node == null) {
            return "";
        }
        if (node instanceof ParserRuleContext) {
            ParserRuleContext prc = (ParserRuleContext)node;
            return Utils.rebuildWithSingleSpaces(tokens, prc);
        }
        if (node instanceof TerminalNode) {
            TerminalNode tn = (TerminalNode)node;
            return tn.getText().trim();
        }
        return node.getText();
    }

    @Deprecated
    public static String reflowTokens(ParserRuleContext ctx) {
        Token start = ctx.getStart();
        Token stop = ctx.getStop();
        if (start == null || stop == null) {
            return "";
        }
        System.out.println("orig: " + ctx.getText());
        String result = start.getInputStream().getText(Interval.of(start.getStartIndex(), stop.getStopIndex()));
        System.out.println("reflow: " + result);
        return result;
    }

    public static HashMap<Integer, String> readLineDirectives(String text) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        try (BufferedReader br = new BufferedReader(new StringReader(text));){
            String line;
            int fileLineNumber = 0;
            while ((line = br.readLine()) != null) {
                ++fileLineNumber;
                Matcher m = LINE_PATTERN.matcher(line);
                if (!m.matches()) continue;
                String payload = m.group(2).trim();
                map.put(fileLineNumber, payload);
            }
        }
        catch (IOException impossible) {
            throw new AssertionError((Object)impossible);
        }
        return map;
    }

    public static String extractSourceLine(Token t) {
        char c;
        char c2;
        int a;
        CharStream input = t.getInputStream();
        if (input == null) {
            return "";
        }
        int start = t.getStartIndex();
        int end = t.getStopIndex();
        int b = end;
        for (a = start; a > 0 && (c2 = input.getText(new Interval(a - 1, a - 1)).charAt(0)) != '\n' && c2 != '\r'; --a) {
        }
        int size = input.size();
        while (b + 1 < size && (c = input.getText(new Interval(b + 1, b + 1)).charAt(0)) != '\n' && c != '\r') {
            ++b;
        }
        return input.getText(new Interval(a, b));
    }
}

